/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.DIGESTMD5BindRequestProperties;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import org.ldaptive.Credential;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.GssApiConfig;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SaslConfig;

public final class UnboundIDSaslUtils {
    private UnboundIDSaslUtils() {
    }

    protected static DIGESTMD5BindRequestProperties createDigestMd5Properties(String username, Credential credential, SaslConfig config) {
        DigestMd5Config c;
        DIGESTMD5BindRequestProperties props = new DIGESTMD5BindRequestProperties(username, credential != null ? credential.getBytes() : null);
        if (config.getAuthorizationId() != null && !"".equals(config.getAuthorizationId())) {
            props.setAuthorizationID(config.getAuthorizationId());
        }
        if (config.getQualityOfProtection() != null) {
            props.setAllowedQoP(new SASLQualityOfProtection[]{UnboundIDSaslUtils.getQualityOfProtection(config.getQualityOfProtection())});
        }
        if (config instanceof DigestMd5Config && (c = (DigestMd5Config)config).getRealm() != null) {
            props.setRealm(c.getRealm());
        }
        return props;
    }

    protected static GSSAPIBindRequestProperties createGssApiProperties(String username, Credential credential, SaslConfig config) {
        GssApiConfig c;
        GSSAPIBindRequestProperties props = new GSSAPIBindRequestProperties(username, credential != null ? credential.getBytes() : null);
        if (config.getAuthorizationId() != null) {
            props.setAuthorizationID(config.getAuthorizationId());
        }
        if (config.getQualityOfProtection() != null) {
            props.setAllowedQoP(new SASLQualityOfProtection[]{UnboundIDSaslUtils.getQualityOfProtection(config.getQualityOfProtection())});
        }
        if (config instanceof GssApiConfig && (c = (GssApiConfig)config).getRealm() != null) {
            props.setRealm(c.getRealm());
        }
        return props;
    }

    protected static SASLQualityOfProtection getQualityOfProtection(QualityOfProtection qop) {
        SASLQualityOfProtection e;
        switch (qop) {
            case AUTH: {
                e = SASLQualityOfProtection.AUTH;
                break;
            }
            case AUTH_INT: {
                e = SASLQualityOfProtection.AUTH_INT;
                break;
            }
            case AUTH_CONF: {
                e = SASLQualityOfProtection.AUTH_CONF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL quality of protection: " + qop);
            }
        }
        return e;
    }
}

