/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDConnection;
import org.ldaptive.provider.unboundid.UnboundIDProviderConfig;

public class UnboundIDStartTLSConnectionFactory
extends AbstractProviderConnectionFactory<UnboundIDProviderConfig> {
    private final SocketFactory socketFactory;
    private final SSLContext sslContext;
    private final LDAPConnectionOptions ldapOptions;

    public UnboundIDStartTLSConnectionFactory(String url, UnboundIDProviderConfig config, SocketFactory factory, SSLContext sslCtx, LDAPConnectionOptions options) {
        super(url, (ProviderConfig)config);
        this.socketFactory = factory;
        this.sslContext = sslCtx;
        this.ldapOptions = options;
    }

    protected UnboundIDConnection createInternal(String url) throws LdapException {
        LdapURL ldapUrl = new LdapURL(url);
        UnboundIDConnection conn = null;
        boolean closeConn = false;
        try {
            LDAPConnection lc = new LDAPConnection(this.socketFactory, this.ldapOptions);
            conn = new UnboundIDConnection(lc, (UnboundIDProviderConfig)this.getProviderConfig());
            lc.connect(ldapUrl.getLastEntry().getHostname(), ldapUrl.getLastEntry().getPort());
            ExtendedResult result = lc.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest(this.sslContext));
            if (result.getResultCode() != com.unboundid.ldap.sdk.ResultCode.SUCCESS) {
                closeConn = true;
                throw new ConnectionException("StartTLS failed", ResultCode.valueOf((int)result.getResultCode().intValue()));
            }
        }
        catch (LDAPException e) {
            closeConn = true;
            throw new ConnectionException((Exception)((Object)e), ResultCode.valueOf((int)e.getResultCode().intValue()));
        }
        finally {
            if (closeConn) {
                try {
                    if (conn != null) {
                        conn.close(null);
                    }
                }
                catch (LdapException e) {
                    this.logger.debug("Problem tearing down connection", (Throwable)e);
                }
            }
        }
        return conn;
    }
}

