/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.xml.AbstractChangeLogParser;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.parser.core.xml.XMLChangeLogSAXHandler;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomStripperInputStream;
import liquibase.util.StreamUtil;
import liquibase.util.file.FilenameUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLChangeLogSAXParser
extends AbstractChangeLogParser {
    public static final String LIQUIBASE_SCHEMA_VERSION = "3.8";
    private static final boolean PREFER_INTERNAL_XSD = Boolean.getBoolean("liquibase.prefer.internal.xsd");
    private static final String XSD_FILE = "dbchangelog-3.8.xsd";
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public XMLChangeLogSAXParser() {
        InputStream xsdInputStream;
        this.saxParserFactory.setValidating(true);
        this.saxParserFactory.setNamespaceAware(true);
        if (PREFER_INTERNAL_XSD && (xsdInputStream = XMLChangeLogSAXParser.class.getResourceAsStream(XSD_FILE)) != null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(new StreamSource(xsdInputStream));
                this.saxParserFactory.setSchema(schema);
                this.saxParserFactory.setValidating(false);
            }
            catch (SAXException e) {
                LogService.getLog(XMLChangeLogSAXParser.class).warning("Could not load dbchangelog-3.8.xsd, enabling parser validator", e);
            }
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public static String getSchemaVersion() {
        return LIQUIBASE_SCHEMA_VERSION;
    }

    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return changeLogFile.toLowerCase().endsWith("xml");
    }

    protected SAXParserFactory getSaxParserFactory() {
        return this.saxParserFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ParsedNode parseToNode(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        try (InputStream inputStream = StreamUtil.singleInputStream(physicalChangeLogLocation, resourceAccessor);){
            SAXParser parser = this.saxParserFactory.newSAXParser();
            this.trySetSchemaLanguageProperty(parser);
            XMLReader xmlReader = parser.getXMLReader();
            LiquibaseEntityResolver resolver = new LiquibaseEntityResolver(this);
            resolver.useResoureAccessor(resourceAccessor, FilenameUtils.getFullPath(physicalChangeLogLocation));
            xmlReader.setEntityResolver(resolver);
            xmlReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    LogService.getLog(this.getClass()).warning(LogType.LOG, exception.getMessage());
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    LogService.getLog(this.getClass()).severe(LogType.LOG, exception.getMessage());
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    LogService.getLog(this.getClass()).severe(LogType.LOG, exception.getMessage());
                    throw exception;
                }
            });
            if (inputStream == null) {
                if (!physicalChangeLogLocation.startsWith("WEB-INF/classes/")) throw new ChangeLogParseException(physicalChangeLogLocation + " does not exist");
                ParsedNode parsedNode = this.parseToNode(physicalChangeLogLocation.replaceFirst("WEB-INF/classes/", ""), changeLogParameters, resourceAccessor);
                return parsedNode;
            }
            XMLChangeLogSAXHandler contentHandler = new XMLChangeLogSAXHandler(physicalChangeLogLocation, resourceAccessor, changeLogParameters);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(new UtfBomStripperInputStream(inputStream)));
            ParsedNode parsedNode = contentHandler.getDatabaseChangeLogTree();
            return parsedNode;
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ChangeLogParseException("Error Reading Migration File: " + e.getMessage(), e);
        }
        catch (SAXParseException e) {
            throw new ChangeLogParseException("Error parsing line " + e.getLineNumber() + " column " + e.getColumnNumber() + " of " + physicalChangeLogLocation + ": " + e.getMessage(), e);
        }
        catch (SAXException e) {
            for (Throwable parentCause = e.getException(); parentCause != null; parentCause = parentCause.getCause()) {
                if (!(parentCause instanceof ChangeLogParseException)) continue;
                throw (ChangeLogParseException)parentCause;
            }
            String reason = e.getMessage();
            String causeReason = null;
            if (e.getCause() != null) {
                causeReason = e.getCause().getMessage();
            }
            if (reason != null) throw new ChangeLogParseException("Invalid Migration File: " + reason, e);
            if (causeReason != null) {
                reason = causeReason;
                throw new ChangeLogParseException("Invalid Migration File: " + reason, e);
            }
            reason = "Unknown Reason";
            throw new ChangeLogParseException("Invalid Migration File: " + reason, e);
        }
        catch (Exception e) {
            throw new ChangeLogParseException(e);
        }
    }

    private void trySetSchemaLanguageProperty(SAXParser parser) {
        try {
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }
}

