/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.ice.ExistingSessionIceCandidatePairFactory;
import org.lastbamboo.common.ice.ExistingSessionIceCandidatePairFactoryImpl;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceBindingRequestTracker;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IceRoleCheckerImpl;
import org.lastbamboo.common.ice.IceStunCheckerFactory;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.candidate.IceCandidatePairState;
import org.lastbamboo.common.stun.client.StunClientMessageVisitor;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.TransportType;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.ice.IceControlledAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControllingAttribute;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IceStunConnectivityCheckerImpl<T>
extends StunClientMessageVisitor<T> {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final IceAgent m_agent;
    private final IceMediaStream m_iceMediaStream;
    private final IoSession m_ioSession;
    private final ExistingSessionIceCandidatePairFactory m_candidatePairFactory;
    private final IceBindingRequestTracker m_bindingRequestTracker;

    public IceStunConnectivityCheckerImpl(IceAgent agent, IoSession session, StunTransactionTracker<T> transactionTracker, IceStunCheckerFactory checkerFactory, IceBindingRequestTracker bindingRequestTracker) {
        super(transactionTracker);
        this.m_agent = agent;
        this.m_iceMediaStream = (IceMediaStream)session.getAttribute(IceMediaStream.class.getSimpleName());
        this.m_ioSession = session;
        this.m_bindingRequestTracker = bindingRequestTracker;
        this.m_candidatePairFactory = new ExistingSessionIceCandidatePairFactoryImpl(checkerFactory);
    }

    public T visitBindingRequest(BindingRequest request) {
        this.m_log.debug("Visiting Binding Request message: {}", (Object)request);
        if (this.m_ioSession.isClosing() || !this.m_ioSession.isConnected()) {
            this.m_log.info("Ignoring binding request for closed session");
            return null;
        }
        if (this.m_bindingRequestTracker.recentlyProcessed(request)) {
            this.m_log.debug("We've recently processed the request -- ignoring duplicate");
            StunMessage response = this.m_bindingRequestTracker.getResponse(request);
            if (response != null) {
                this.m_log.info("Writing same response again");
                this.m_ioSession.write((Object)response);
            } else {
                this.m_log.warn("Received dup request before mapping response?");
            }
            return null;
        }
        this.m_bindingRequestTracker.add(request);
        if (this.fromOurselves(this.m_agent, request)) {
            this.m_log.error("Received a request from us on: {}", (Object)this.m_ioSession);
            return null;
        }
        this.m_log.debug("Not from ourselves...");
        IceRoleCheckerImpl checker = new IceRoleCheckerImpl();
        BindingErrorResponse errorResponse = checker.checkAndRepairRoles(request, this.m_agent, this.m_ioSession);
        this.m_log.debug("Checked role conflict...");
        if (errorResponse != null) {
            this.m_log.debug("Sending error response...");
            this.m_ioSession.write((Object)errorResponse);
            this.m_bindingRequestTracker.addResponse(request, (StunMessage)errorResponse);
        } else {
            this.m_log.debug("Processing no role conflict...");
            this.processNoRoleConflict(request);
        }
        return null;
    }

    private void processNoRoleConflict(BindingRequest binding) {
        IceCandidatePairState state;
        IceCandidatePair computedPair;
        IceCandidate remoteCandidate;
        if (binding.getAttributes().containsKey(StunAttributeType.ICE_USE_CANDIDATE)) {
            this.m_log.debug("GOT BINDING REQUEST WITH USE CANDIDATE");
        }
        InetSocketAddress localAddress = (InetSocketAddress)this.m_ioSession.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)this.m_ioSession.getRemoteAddress();
        this.m_log.debug("Using normal remote address: {}", (Object)remoteAddress);
        UUID transactionId = binding.getTransactionId();
        BindingSuccessResponse response = new BindingSuccessResponse(transactionId.getRawBytes(), remoteAddress);
        this.m_log.debug("Writing success response...");
        this.m_ioSession.write((Object)response);
        this.m_bindingRequestTracker.addResponse(binding, (StunMessage)response);
        TransportType type = this.m_ioSession.getTransportType();
        boolean isUdp = type.isConnectionless();
        if (!this.m_iceMediaStream.hasRemoteCandidate(remoteAddress, isUdp)) {
            this.m_log.debug("New remote candidate...");
            remoteCandidate = this.m_iceMediaStream.addRemotePeerReflexive(binding, localAddress, remoteAddress, isUdp);
            this.m_log.debug("Added peer reflexive remote candidate: {}", (Object)remoteCandidate);
        } else {
            remoteCandidate = this.m_iceMediaStream.getRemoteCandidate(remoteAddress, isUdp);
        }
        IceCandidate localCandidate = this.m_iceMediaStream.getLocalCandidate(localAddress, isUdp);
        this.m_log.debug("Using existing local candidate: {}", (Object)localCandidate);
        if (localCandidate == null) {
            this.m_log.warn("Could not create local candidate.");
            return;
        }
        if (remoteCandidate == null) {
            this.m_log.warn("Could not find remote candidate.");
            return;
        }
        IceCandidatePair existingPair = this.m_iceMediaStream.getPair(localAddress, remoteAddress, localCandidate.isUdp());
        if (existingPair != null) {
            this.m_log.debug("Found existing pair");
            computedPair = existingPair;
            state = computedPair.getState();
            switch (state) {
                case WAITING: 
                case FROZEN: {
                    this.m_log.debug("Adding triggered check for previously frozen or waiting pair:\n{}", (Object)existingPair);
                    this.m_iceMediaStream.addTriggeredPair(existingPair);
                    break;
                }
                case IN_PROGRESS: {
                    this.m_log.info("Pair is IN PROGRESS...nominating on success");
                    break;
                }
                case FAILED: {
                    existingPair.setState(IceCandidatePairState.WAITING);
                    this.m_iceMediaStream.addTriggeredPair(existingPair);
                    break;
                }
                case SUCCEEDED: {
                    this.m_log.debug("Pair has already been checked and SUCCEEDED");
                }
            }
        } else {
            this.m_log.debug("Creating new candidate pair.");
            computedPair = this.m_candidatePairFactory.newUdpPair(localCandidate, remoteCandidate, this.m_ioSession);
            this.m_iceMediaStream.addPair(computedPair);
            computedPair.setState(IceCandidatePairState.WAITING);
            this.m_iceMediaStream.addTriggeredPair(computedPair);
        }
        if (binding.getAttributes().containsKey(StunAttributeType.ICE_USE_CANDIDATE) && !this.m_agent.isControlling()) {
            computedPair.useCandidate();
            state = computedPair.getState();
            switch (state) {
                case SUCCEEDED: {
                    this.m_log.debug("Nominating pair on controlled agent:\n{}", (Object)computedPair);
                    computedPair.nominate();
                    this.m_agent.onNominatedPair(computedPair, this.m_iceMediaStream);
                    break;
                }
                case IN_PROGRESS: {
                    computedPair.nominateOnSuccess();
                    break;
                }
                case WAITING: {
                    break;
                }
                case FROZEN: {
                    break;
                }
            }
        }
    }

    private boolean fromOurselves(IceAgent agent, BindingRequest request) {
        byte[] remoteTieBreaker;
        IceControlledAttribute attribute;
        Map remoteAttributes = request.getAttributes();
        if (remoteAttributes.containsKey(StunAttributeType.ICE_CONTROLLED)) {
            attribute = (IceControlledAttribute)remoteAttributes.get(StunAttributeType.ICE_CONTROLLED);
            remoteTieBreaker = attribute.getTieBreaker();
        } else {
            attribute = (IceControllingAttribute)remoteAttributes.get(StunAttributeType.ICE_CONTROLLING);
            if (attribute == null) {
                this.m_log.error("No controlling attribute");
                return false;
            }
            remoteTieBreaker = attribute.getTieBreaker();
        }
        byte[] localTieBreaker = agent.getTieBreaker().toByteArray();
        return Arrays.equals(localTieBreaker, remoteTieBreaker);
    }
}

