/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.PriorityBlockingQueue;
import org.lastbamboo.common.ice.PortMappedServerSocket;
import org.lastbamboo.common.portmapping.NatPmpService;
import org.lastbamboo.common.portmapping.PortMapListener;
import org.lastbamboo.common.portmapping.PortMappingProtocol;
import org.lastbamboo.common.portmapping.UpnpService;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMappedServerPool {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private static final int NUM_SERVERS = 4;
    private final PriorityBlockingQueue<PortMappedServerSocket> m_mappedServers = new PriorityBlockingQueue();
    private final NatPmpService natPmpService;
    private final UpnpService upnpService;

    public PortMappedServerPool(NatPmpService natPmpService, UpnpService upnpService) {
        this.natPmpService = natPmpService;
        this.upnpService = upnpService;
        for (int i = 0; i < 4; ++i) {
            try {
                this.addServer();
                continue;
            }
            catch (IOException e) {
                this.m_log.warn("Could not add server", (Throwable)e);
            }
        }
    }

    public PortMappedServerSocket getServer() throws IOException {
        try {
            PortMappedServerSocket serverSocket = this.m_mappedServers.take();
            this.addServer();
            return serverSocket;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Could not get a server??");
        }
    }

    private void addServer() throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        InetAddress lh = NetworkUtils.getLocalHost();
        serverSocket.bind(new InetSocketAddress(lh, 0));
        InetSocketAddress socketAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
        int port = socketAddress.getPort();
        PortMapListener upnpPortMapListener = new PortMapListener(){

            public void onPortMapError() {
            }

            public void onPortMap(int externalPort) {
            }
        };
        PortMapListener natPmpPortMapListener = new PortMapListener(){

            public void onPortMapError() {
            }

            public void onPortMap(int externalPort) {
            }
        };
        this.upnpService.addUpnpMapping(PortMappingProtocol.TCP, port, port, upnpPortMapListener);
        this.natPmpService.addNatPmpMapping(PortMappingProtocol.TCP, port, port, natPmpPortMapListener);
        PortMappedServerSocket server = new PortMappedServerSocket(serverSocket, NetworkUtils.isPublicAddress((InetAddress)lh));
        this.m_mappedServers.add(server);
    }
}

