/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.UdpSocketFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.stun.server.StunServer;
import org.littleshoot.mina.common.IoAcceptor;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDTClient;
import udt.UDTReceiver;
import udt.UDTServerSocket;
import udt.UDTSocket;

public class UdtSocketFactory
implements UdpSocketFactory<Socket> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService m_threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        private int threadNumber = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "UDT-Socket-Accept-Thread-" + this.threadNumber);
            t.setDaemon(true);
            ++this.threadNumber;
            return t;
        }
    });

    @Override
    public void newEndpoint(final IoSession session, boolean controlling, final OfferAnswerListener<Socket> socketListener, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        if (session == null) {
            this.log.error("Null session: {}", (Object)session);
            return;
        }
        if (controlling) {
            long sleepTime = 1200L;
            this.log.info("Client side sleeping for {} milliseconds", (Object)1200L);
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                this.log.warn("Sleep interrupted?", (Throwable)e);
            }
        }
        UDTReceiver.connectionExpiryDisabled = true;
        this.clear(session, stunUdpPeer, iceAgent);
        if (!controlling) {
            this.log.debug("Creating UDT client socket on CONTROLLED agent.");
            Runnable clientRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        UdtSocketFactory.this.openServerSocket(session, (OfferAnswerListener<Socket>)socketListener);
                    }
                    catch (Throwable t) {
                        UdtSocketFactory.this.log.error("Client socket exception", t);
                    }
                }
            };
            Thread udtClientThread = new Thread(clientRunner, "UDT Client Thread");
            udtClientThread.setDaemon(true);
            udtClientThread.start();
        } else {
            this.log.debug("Creating UDT server socket on CONTROLLING agent.");
            this.log.debug("Listening on: {}", (Object)session);
            Runnable serverRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        UdtSocketFactory.this.openClientSocket(session, (OfferAnswerListener<Socket>)socketListener);
                    }
                    catch (Throwable t) {
                        UdtSocketFactory.this.log.error("Server socket exception", t);
                    }
                }
            };
            Thread serverThread = new Thread(serverRunner, "UDT Accepting Thread");
            serverThread.setDaemon(true);
            serverThread.start();
        }
    }

    protected void openClientSocket(IoSession session, OfferAnswerListener<Socket> socketListener) throws InterruptedException, IOException {
        InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
        InetSocketAddress remote = (InetSocketAddress)session.getRemoteAddress();
        this.log.info("Session local was: {}", (Object)local);
        this.log.info("Binding to port: {}", (Object)local.getPort());
        UDTClient client = new UDTClient(local.getAddress(), local.getPort());
        this.log.info("About to connect...");
        client.connect(remote.getAddress(), remote.getPort());
        this.log.info("Connected!!!");
        Socket sock = client.getSocket();
        this.log.info("Got socket...notifying listener");
        socketListener.onUdpSocket((Object)sock);
        this.log.info("Exiting...");
    }

    protected void openServerSocket(IoSession session, OfferAnswerListener<Socket> socketListener) throws InterruptedException, IOException {
        InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
        this.log.info("Session local was: {}", (Object)local);
        this.log.info("Binding to port: {}", (Object)local.getPort());
        UDTServerSocket server = new UDTServerSocket(local.getAddress(), local.getPort());
        UDTSocket sock = server.accept();
        this.m_threadPool.execute(new RequestRunner(socketListener, sock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(IoSession session, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        this.log.info("Closing ICE agent");
        iceAgent.close();
        this.log.info("Clearing session!!");
        DatagramSessionImpl dgSession = (DatagramSessionImpl)session;
        DatagramChannel dgChannel = dgSession.getChannel();
        session.close().join(10000L);
        StunServer stunServer = stunUdpPeer.getStunServer();
        stunServer.close();
        try {
            IoService service = session.getService();
            this.log.info("Service is: {}", (Object)service);
            if (IoAcceptor.class.isAssignableFrom(service.getClass())) {
                this.log.info("Unbinding all!!");
                IoAcceptor acceptor = (IoAcceptor)service;
                acceptor.unbindAll();
            }
            session.getService().getFilterChain().clear();
            dgChannel.disconnect();
            dgChannel.close();
        }
        catch (Exception e) {
            this.log.error("Error clearing session!!", (Throwable)e);
        }
        finally {
            stunUdpPeer.close();
        }
    }

    public static class RequestRunner
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final UDTSocket sock;
        private final OfferAnswerListener<Socket> socketListener;

        public RequestRunner(OfferAnswerListener<Socket> socketListener, UDTSocket sock) {
            this.socketListener = socketListener;
            this.sock = sock;
        }

        @Override
        public void run() {
            this.log.info("NOTIFYING SOCKET LISTENER!!");
            this.socketListener.onUdpSocket((Object)this.sock);
        }
    }
}

