/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IceCandidateType {
    HOST(126, "host"),
    RELAYED(0, "relay"),
    SERVER_REFLEXIVE(100, "srflx"),
    PEER_REFLEXIVE(110, "prflx");

    private final int m_typePreference;
    private final String m_sdp;
    private static final Logger LOG;
    private static final Map<String, IceCandidateType> s_sdpToType;

    private IceCandidateType(int typePreference, String sdp) {
        this.m_typePreference = typePreference;
        this.m_sdp = sdp;
    }

    public int getTypePreference() {
        return this.m_typePreference;
    }

    public String toSdp() {
        return this.m_sdp;
    }

    public static IceCandidateType toType(String sdp) {
        IceCandidateType type = s_sdpToType.get(sdp);
        if (type == null) {
            LOG.error("No matching type for: " + sdp);
        }
        return type;
    }

    static {
        LOG = LoggerFactory.getLogger(IceCandidateType.class);
        s_sdpToType = new HashMap<String, IceCandidateType>();
        for (IceCandidateType type : IceCandidateType.values()) {
            s_sdpToType.put(type.toSdp(), type);
        }
    }
}

