/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.common;

import java.net.SocketAddress;
import java.util.ArrayList;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.IoSessionRecycler;
import org.littleshoot.mina.util.ExpirationListener;
import org.littleshoot.mina.util.ExpiringMap;

public class ExpiringSessionRecycler
implements IoSessionRecycler {
    private ExpiringMap<Object, IoSession> sessionMap;
    private ExpiringMap.Expirer mapExpirer;

    public ExpiringSessionRecycler() {
        this(60);
    }

    public ExpiringSessionRecycler(int timeToLive) {
        this(timeToLive, 1);
    }

    public ExpiringSessionRecycler(int timeToLive, int expirationInterval) {
        this.sessionMap = new ExpiringMap(timeToLive, expirationInterval);
        this.mapExpirer = this.sessionMap.getExpirer();
        this.sessionMap.addExpirationListener(new DefaultExpirationListener());
    }

    @Override
    public void put(IoSession session) {
        this.mapExpirer.startExpiringIfNotStarted();
        Object key = this.generateKey(session);
        if (!this.sessionMap.containsKey(key)) {
            this.sessionMap.put(key, session);
        }
    }

    @Override
    public IoSession recycle(SocketAddress localAddress, SocketAddress remoteAddress) {
        return this.sessionMap.get(this.generateKey(localAddress, remoteAddress));
    }

    @Override
    public void remove(IoSession session) {
        this.sessionMap.remove(this.generateKey(session));
    }

    public void stopExpiring() {
        this.mapExpirer.stopExpiring();
    }

    public int getExpirationInterval() {
        return this.sessionMap.getExpirationInterval();
    }

    public int getTimeToLive() {
        return this.sessionMap.getTimeToLive();
    }

    public void setExpirationInterval(int expirationInterval) {
        this.sessionMap.setExpirationInterval(expirationInterval);
    }

    public void setTimeToLive(int timeToLive) {
        this.sessionMap.setTimeToLive(timeToLive);
    }

    private Object generateKey(IoSession session) {
        return this.generateKey(session.getLocalAddress(), session.getRemoteAddress());
    }

    private Object generateKey(SocketAddress localAddress, SocketAddress remoteAddress) {
        ArrayList<SocketAddress> key = new ArrayList<SocketAddress>(2);
        key.add(remoteAddress);
        key.add(localAddress);
        return key;
    }

    private class DefaultExpirationListener
    implements ExpirationListener<IoSession> {
        private DefaultExpirationListener() {
        }

        @Override
        public void expired(IoSession expiredSession) {
            expiredSession.close();
        }
    }
}

