/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.filter.executor;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoFilterAdapter;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorFilter
extends IoFilterAdapter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Executor executor;

    public ExecutorFilter() {
        this(new ThreadPoolExecutor(16, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorFilter(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(IoFilter.NextFilter nextFilter, IoSession session, EventType type, Object data) {
        boolean execute;
        Event event = new Event(type, nextFilter, data);
        SessionBuffer buf = SessionBuffer.getSessionBuffer(session);
        Queue queue = buf.eventQueue;
        synchronized (queue) {
            buf.eventQueue.offer(event);
            if (buf.processingCompleted) {
                buf.processingCompleted = false;
                execute = true;
            } else {
                execute = false;
            }
        }
        if (execute) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Launching thread for " + session.getRemoteAddress());
            }
            this.executor.execute(new ProcessEventsRunnable(buf));
        }
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        nextFilter.sessionCreated(session);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.OPENED, null);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.CLOSED, null);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        this.fireEvent(nextFilter, session, EventType.IDLE, status);
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        this.fireEvent(nextFilter, session, EventType.EXCEPTION, cause);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        this.fireEvent(nextFilter, session, EventType.RECEIVED, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        this.fireEvent(nextFilter, session, EventType.SENT, message);
    }

    protected void processEvent(IoFilter.NextFilter nextFilter, IoSession session, EventType type, Object data) {
        if (type == EventType.RECEIVED) {
            nextFilter.messageReceived(session, data);
        } else if (type == EventType.SENT) {
            nextFilter.messageSent(session, data);
        } else if (type == EventType.EXCEPTION) {
            nextFilter.exceptionCaught(session, (Throwable)data);
        } else if (type == EventType.IDLE) {
            nextFilter.sessionIdle(session, (IdleStatus)data);
        } else if (type == EventType.OPENED) {
            nextFilter.sessionOpened(session);
        } else if (type == EventType.CLOSED) {
            nextFilter.sessionClosed(session);
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) {
        nextFilter.filterWrite(session, writeRequest);
    }

    @Override
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.filterClose(session);
    }

    private class ProcessEventsRunnable
    implements Runnable {
        private final SessionBuffer buffer;

        ProcessEventsRunnable(SessionBuffer buffer) {
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Event event;
                Queue queue = this.buffer.eventQueue;
                synchronized (queue) {
                    event = (Event)this.buffer.eventQueue.poll();
                    if (event == null) {
                        this.buffer.processingCompleted = true;
                        break;
                    }
                }
                ExecutorFilter.this.processEvent(event.getNextFilter(), this.buffer.session, event.getType(), event.getData());
            }
            if (ExecutorFilter.this.logger.isDebugEnabled()) {
                ExecutorFilter.this.logger.debug("Exiting since queue is empty for " + this.buffer.session.getRemoteAddress());
            }
        }
    }

    protected static class Event {
        private final EventType type;
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        Event(EventType type, IoFilter.NextFilter nextFilter, Object data) {
            this.type = type;
            this.nextFilter = nextFilter;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public EventType getType() {
            return this.type;
        }
    }

    protected static class EventType {
        public static final EventType OPENED = new EventType("OPENED");
        public static final EventType CLOSED = new EventType("CLOSED");
        public static final EventType READ = new EventType("READ");
        public static final EventType WRITTEN = new EventType("WRITTEN");
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType SENT = new EventType("SENT");
        public static final EventType IDLE = new EventType("IDLE");
        public static final EventType EXCEPTION = new EventType("EXCEPTION");
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class SessionBuffer {
        private static final String KEY = SessionBuffer.class.getName() + ".KEY";
        private final IoSession session;
        private final Queue<Event> eventQueue = new LinkedList<Event>();
        private boolean processingCompleted = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SessionBuffer getSessionBuffer(IoSession session) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                SessionBuffer buf = (SessionBuffer)session.getAttribute(KEY);
                if (buf == null) {
                    buf = new SessionBuffer(session);
                    session.setAttribute(KEY, buf);
                }
                return buf;
            }
        }

        private SessionBuffer(IoSession session) {
            this.session = session;
        }
    }
}

