/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoSessionConfig;
import org.littleshoot.mina.common.support.BaseIoAcceptor;
import org.littleshoot.mina.common.support.BaseIoAcceptorConfig;
import org.littleshoot.mina.common.support.BaseIoSessionConfig;
import org.littleshoot.mina.transport.vmpipe.VmPipeAddress;
import org.littleshoot.mina.transport.vmpipe.support.VmPipe;

public class VmPipeAcceptor
extends BaseIoAcceptor {
    static final Map<SocketAddress, VmPipe> boundHandlers = new HashMap<SocketAddress, VmPipe>();
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoAcceptorConfig(){

        @Override
        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (address != null && !(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        Map<SocketAddress, VmPipe> map = boundHandlers;
        synchronized (map) {
            if (address == null || ((VmPipeAddress)address).getPort() == 0) {
                for (int i = 1; i < Integer.MAX_VALUE && boundHandlers.containsKey(address = new VmPipeAddress(i)); ++i) {
                }
            } else if (boundHandlers.containsKey(address)) {
                throw new IOException("Address already bound: " + address);
            }
            boundHandlers.put(address, new VmPipe(this, (VmPipeAddress)address, handler, config, this.getListeners()));
        }
        this.getListeners().fireServiceActivated(this, address, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(SocketAddress address) {
        VmPipe pipe;
        if (address == null) {
            throw new NullPointerException("address");
        }
        Map<SocketAddress, VmPipe> map = boundHandlers;
        synchronized (map) {
            if (!boundHandlers.containsKey(address)) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            pipe = boundHandlers.remove(address);
        }
        this.getListeners().fireServiceDeactivated(this, pipe.getAddress(), pipe.getHandler(), pipe.getConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        Map<SocketAddress, VmPipe> map = boundHandlers;
        synchronized (map) {
            for (SocketAddress address : new ArrayList<SocketAddress>(boundHandlers.keySet())) {
                this.unbind(address);
            }
        }
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

