/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamePreservingRunnable
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(NamePreservingRunnable.class);
    private final String newName;
    private final Runnable runnable;

    public NamePreservingRunnable(Runnable runnable, String newName) {
        this.runnable = runnable;
        this.newName = newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        if (this.newName != null) {
            this.setName(currentThread, this.newName);
        }
        try {
            this.runnable.run();
        }
        finally {
            this.setName(currentThread, oldName);
        }
    }

    private void setName(Thread thread, String name) {
        block2: {
            try {
                thread.setName(name);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Failed to set the thread name.", (Throwable)e);
            }
        }
    }
}

