/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.offer.answer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.offer.answer.OfferAnswer;
import org.lastbamboo.common.offer.answer.OfferAnswerConnectException;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.sdp.api.MediaDescription;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpFactory;
import org.lastbamboo.common.sdp.api.SessionDescription;
import org.littleshoot.util.RelayingSocketHandler;
import org.littleshoot.util.SessionSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnswererOfferAnswerListener
implements OfferAnswerListener<Socket> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String id;
    private final SessionSocketListener callSocketListener;
    private final boolean message;
    private final InetSocketAddress plainTextRelayAddress;

    public AnswererOfferAnswerListener(String id, InetSocketAddress plainTextRelayAddress, SessionSocketListener callSocketListener, String offer) throws OfferAnswerConnectException {
        this.id = id;
        this.plainTextRelayAddress = plainTextRelayAddress;
        this.callSocketListener = callSocketListener;
        this.message = this.isMessage(offer);
    }

    private boolean isMessage(String offer) throws OfferAnswerConnectException {
        SdpFactory sdpFactory = new SdpFactory();
        try {
            SessionDescription sdp = sdpFactory.createSessionDescription(offer);
            Vector mediaDescriptions = sdp.getMediaDescriptions(true);
            this.log.debug("Creating candidates from media descs:\n" + mediaDescriptions);
            for (MediaDescription mediaDesc : mediaDescriptions) {
                String mediaType = mediaDesc.getMedia().getMediaType();
                if (!StringUtils.isNotBlank((String)mediaType) || !mediaType.trim().equalsIgnoreCase("message")) continue;
                return true;
            }
            return false;
        }
        catch (SdpException e) {
            this.log.warn("Could not parse SDP: " + offer);
            throw new OfferAnswerConnectException("Could not parse SDP", (Exception)((Object)e));
        }
    }

    @Override
    public void onOfferAnswerFailed(OfferAnswer offerAnswer) {
        this.log.warn("Offer/Answer failed.  Not starting media for: {}", (Object)offerAnswer);
    }

    @Override
    public void onTcpSocket(Socket sock) {
        this.log.info("Received TCP socket");
        this.onSocket(sock);
    }

    @Override
    public void onUdpSocket(Socket sock) {
        this.log.info("Received UDP socket");
        this.onSocket(sock);
    }

    private void onSocket(Socket sock) {
        this.log.info("Got socket on listener!!");
        try {
            sock.setSoTimeout(2400000);
            if (this.message) {
                RelayingSocketHandler rsh = new RelayingSocketHandler(this.plainTextRelayAddress);
                rsh.onSocket(this.id, sock);
            } else {
                this.callSocketListener.onSocket(this.id, sock);
            }
        }
        catch (IOException e) {
            this.log.warn("Exception processing socket", (Throwable)e);
            try {
                sock.close();
            }
            catch (IOException e1) {
                this.log.warn("Could not close socket", (Throwable)e1);
            }
        }
    }
}

