/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.offer.answer;

import org.lastbamboo.common.offer.answer.IceConfig;

public final class IceMediaStreamDesc {
    private final boolean m_udp;
    private final boolean m_tcp;
    private final String m_mimeContentType;
    private final String m_mimeContentSubtype;
    private final int m_numComponents;
    private final boolean m_useRelay;
    private final boolean reliable;

    public static IceMediaStreamDesc newUnreliableUdpStream() {
        return new IceMediaStreamDesc(false, true, "application", "udp", 1, true, false);
    }

    public static IceMediaStreamDesc newUnreliableUdpStreamNoRelay() {
        return new IceMediaStreamDesc(false, true, "application", "udp", 1, false, false);
    }

    public static IceMediaStreamDesc newReliable() {
        return new IceMediaStreamDesc(IceConfig.isTcp(), IceConfig.isUdp(), "message", "http", 1, true, true);
    }

    public static IceMediaStreamDesc newReliableNoRelay() {
        return new IceMediaStreamDesc(IceConfig.isTcp(), IceConfig.isUdp(), "message", "http", 1, false, true);
    }

    public static IceMediaStreamDesc allStreams() {
        return new IceMediaStreamDesc(true, true, "message", "http", 1, true, true);
    }

    public IceMediaStreamDesc(String mimeContentType, String mimeContentSubtype, int numComponents, boolean useRelay) {
        this(IceConfig.isTcp(), IceConfig.isUdp(), mimeContentType, mimeContentSubtype, numComponents, useRelay, true);
    }

    public IceMediaStreamDesc(boolean tcp, boolean udp, String mimeContentType, String mimeContentSubtype, int numComponents, boolean useRelay) {
        this(tcp, udp, mimeContentType, mimeContentSubtype, numComponents, useRelay, true);
    }

    public IceMediaStreamDesc(boolean tcp, boolean udp, String mimeContentType, String mimeContentSubtype, int numComponents, boolean useRelay, boolean reliable) {
        this.m_tcp = tcp;
        this.m_udp = udp;
        this.m_mimeContentType = mimeContentType;
        this.m_mimeContentSubtype = mimeContentSubtype;
        this.m_numComponents = numComponents;
        this.m_useRelay = useRelay;
        this.reliable = reliable;
    }

    public String getMimeContentSubtype() {
        return this.m_mimeContentSubtype;
    }

    public String getMimeContentType() {
        return this.m_mimeContentType;
    }

    public boolean isTcp() {
        return this.m_tcp;
    }

    public boolean isUdp() {
        return this.m_udp;
    }

    public int getNumComponents() {
        return this.m_numComponents;
    }

    public boolean isUseRelay() {
        return this.m_useRelay;
    }

    public boolean isReliable() {
        return this.reliable;
    }
}

