/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.lastbamboo.common.stun.client.StunServerRepository;
import org.lastbamboo.common.stun.client.UdpStunClient;
import org.littleshoot.util.PublicIp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicIpAddress
implements PublicIp {
    private static final Logger LOG = LoggerFactory.getLogger(PublicIpAddress.class);
    private static InetAddress publicIp;
    private static long lastLookupTime;
    private final long cacheTime;
    private static final ExecutorService threadPool;

    public PublicIpAddress() {
        this.cacheTime = 100L;
    }

    public PublicIpAddress(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public InetAddress getPublicIpAddress() {
        long now = System.currentTimeMillis();
        if (now - lastLookupTime < this.cacheTime * 1000L && (now - lastLookupTime < 2000L || publicIp != null)) {
            return publicIp;
        }
        try {
            publicIp = this.stunLookup();
            return publicIp;
        }
        catch (InterruptedException e) {
            LOG.error("Could not perform STUN lookup", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Could not perform STUN lookup", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.error("Could not perform STUN lookup", (Throwable)e);
        }
        publicIp = PublicIpAddress.wikiMediaLookup();
        if (publicIp != null) {
            lastLookupTime = System.currentTimeMillis();
            return publicIp;
        }
        publicIp = PublicIpAddress.ifConfigLookup();
        if (publicIp != null) {
            lastLookupTime = System.currentTimeMillis();
            return publicIp;
        }
        return null;
    }

    private InetAddress stunLookup() throws InterruptedException, ExecutionException, TimeoutException {
        Collection<InetSocketAddress> servers = StunServerRepository.getServers();
        ArrayList<2> tasks = new ArrayList<2>(servers.size());
        for (final InetSocketAddress sock : servers) {
            Callable<InetAddress> task = new Callable<InetAddress>(){

                @Override
                public InetAddress call() throws Exception {
                    UdpStunClient stun = new UdpStunClient(sock);
                    stun.connect();
                    publicIp = stun.getServerReflexiveAddress().getAddress();
                    lastLookupTime = System.currentTimeMillis();
                    return publicIp;
                }
            };
            tasks.add(task);
        }
        return (InetAddress)threadPool.invokeAny(tasks, 12L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress ifConfigLookup() {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod("http://ifconfig.me");
        get.setRequestHeader("User-Agent", "curl/7.19.7 (universal-apple-darwin10.0) libcurl/7.19.7 OpenSSL/0.9.8r zlib/1.2.3");
        get.setFollowRedirects(true);
        try {
            int response = client.executeMethod((HttpMethod)get);
            if (response < 200 || response > 299) {
                LOG.warn("Got non-200 level response: " + response);
                InetAddress inetAddress = null;
                return inetAddress;
            }
            String body = new String(get.getResponseBody(), "UTF-8");
            LOG.info("Got response body:\n{}", (Object)body);
            InetAddress inetAddress = InetAddress.getByName(body.trim());
            return inetAddress;
        }
        catch (HttpException e) {
            LOG.warn("HTTP error?", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Error connecting?", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Some other error?", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress wikiMediaLookup() {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod("http://geoiplookup.wikimedia.org/");
        get.setFollowRedirects(true);
        try {
            int response = client.executeMethod((HttpMethod)get);
            if (response < 200 || response > 299) {
                LOG.warn("Got non-200 level response: " + response);
                InetAddress inetAddress = null;
                return inetAddress;
            }
            String body = new String(get.getResponseBody(), "UTF-8");
            LOG.info("Got response body:\n{}", (Object)body);
            String jsonStr = StringUtils.substringAfter((String)body, (String)"=").trim();
            JSONObject json = (JSONObject)JSONValue.parse((String)jsonStr);
            String inet = (String)json.get((Object)"IP");
            InetAddress inetAddress = InetAddress.getByName(inet);
            return inetAddress;
        }
        catch (HttpException e) {
            LOG.warn("HTTP error?", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Error connecting?", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Some other error?", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    static {
        threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            private int count = 0;

            @Override
            public Thread newThread(Runnable runner) {
                Thread thread = new Thread(runner, "Public-IP-Lookup-Thread-" + this.count);
                thread.setDaemon(true);
                ++this.count;
                return thread;
            }
        });
    }
}

