/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.client;

import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorAdapter;
import org.littleshoot.stun.stack.transaction.StunClientTransaction;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunClientMessageVisitor<T>
extends StunMessageVisitorAdapter<T> {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final StunTransactionTracker<T> m_transactionTracker;

    public StunClientMessageVisitor(StunTransactionTracker<T> transactionTracker) {
        this.m_transactionTracker = transactionTracker;
    }

    public T visitConnectErrorMesssage(ConnectErrorStunMessage message) {
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Received ICMP error: {}", (Object)message);
        }
        return this.notifyTransaction((StunMessage)message);
    }

    public T visitBindingErrorResponse(BindingErrorResponse response) {
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Received Binding Error response: {}", (Object)response);
        }
        return this.notifyTransaction((StunMessage)response);
    }

    public T visitBindingSuccessResponse(BindingSuccessResponse response) {
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Received Binding Response: {}", (Object)response);
        }
        return this.notifyTransaction((StunMessage)response);
    }

    private T notifyTransaction(StunMessage response) {
        StunClientTransaction ct = this.m_transactionTracker.getClientTransaction(response);
        this.m_log.debug("Accessed transaction: {}", (Object)ct);
        if (ct == null) {
            this.m_log.debug("No matching transaction for response: {}", (Object)response);
            return null;
        }
        return (T)response.accept((StunMessageVisitor)ct);
    }
}

