/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.stun.client.StunClient;
import org.lastbamboo.common.stun.client.StunClientConfig;
import org.lastbamboo.common.stun.client.StunClientMessageVisitorFactory;
import org.littleshoot.dnssec4j.DNSSECException;
import org.littleshoot.dnssec4j.DnsSec;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExecutorThreadModel;
import org.littleshoot.mina.common.IoConnector;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolCodecFilter;
import org.littleshoot.mina.transport.socket.nio.DatagramConnector;
import org.littleshoot.mina.transport.socket.nio.DatagramConnectorConfig;
import org.littleshoot.stun.stack.StunIoHandler;
import org.littleshoot.stun.stack.StunProtocolCodecFactory;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.NullStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorAdapter;
import org.littleshoot.stun.stack.transaction.StunTransactionListener;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.littleshoot.stun.stack.transaction.StunTransactionTrackerImpl;
import org.littleshoot.util.CandidateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpStunClient
implements StunClient,
StunTransactionListener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpStunClient.class);
    private final Collection<IoServiceListener> m_ioServiceListeners = new ArrayList<IoServiceListener>();
    private RankedStunServer m_stunServer;
    private final IoHandler m_ioHandler;
    private final Map<UUID, StunMessage> m_idsToResponses = new ConcurrentHashMap<UUID, StunMessage>();
    private InetSocketAddress m_localAddress;
    private IoSession m_currentIoSession;
    private final StunTransactionTracker<StunMessage> m_transactionTracker;
    private final InetSocketAddress m_originalLocalAddress;
    private final Collection<IoSession> m_sessions = new ArrayList<IoSession>();
    private final Queue<RankedStunServer> m_stunServers = new PriorityQueue<RankedStunServer>();

    public UdpStunClient(StunTransactionTracker<StunMessage> transactionTracker, IoHandler ioHandler, CandidateProvider<InetSocketAddress> stunServerCandidateProvider) throws IOException {
        this(null, stunServerCandidateProvider.getCandidates(), transactionTracker, ioHandler);
    }

    public UdpStunClient(CandidateProvider<InetSocketAddress> stunServerCandidateProvider) throws IOException {
        this(null, stunServerCandidateProvider.getCandidates(), null, null);
    }

    public UdpStunClient(InetSocketAddress ... stunServers) throws IOException {
        this(null, Arrays.asList(stunServers), null, null);
    }

    public UdpStunClient(Collection<InetSocketAddress> stunServers) throws IOException {
        this(null, stunServers, null, null);
    }

    private UdpStunClient(InetSocketAddress localAddress, Collection<InetSocketAddress> stunServers, StunTransactionTracker<StunMessage> transactionTracker, IoHandler ioHandler) throws IOException {
        if (stunServers == null) {
            LOG.error("Null STUN server provider");
            throw new NullPointerException("Null STUN server provider");
        }
        LOG.info("Creating UDP STUN CLIENT");
        for (InetSocketAddress isa : stunServers) {
            try {
                this.m_stunServers.add(new RankedStunServer(isa));
            }
            catch (DNSSECException e) {
                LOG.warn("DNSSEC verification error!!", (Throwable)e);
            }
        }
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        this.m_originalLocalAddress = localAddress;
        this.m_transactionTracker = transactionTracker == null ? new StunTransactionTrackerImpl() : transactionTracker;
        this.m_stunServer = this.pickStunServerInetAddress();
        if (ioHandler == null) {
            StunClientMessageVisitorFactory<StunMessage> messageVisitorFactoryToUse = new StunClientMessageVisitorFactory<StunMessage>(this.m_transactionTracker);
            this.m_ioHandler = new StunIoHandler(messageVisitorFactoryToUse);
        } else {
            this.m_ioHandler = ioHandler;
        }
    }

    @Override
    public void connect() throws IOException {
        IoSession session;
        try {
            session = this.connect(this.m_originalLocalAddress, this.m_stunServer.isa);
        }
        catch (IOException e) {
            this.onFailure(this.m_stunServer);
            throw e;
        }
        this.m_localAddress = (InetSocketAddress)session.getLocalAddress();
    }

    private void onFailure(RankedStunServer rss) throws IOException {
        if (this.m_stunServer.failures < 5) {
            this.m_stunServer.failures++;
            this.m_stunServers.remove(rss);
            this.m_stunServers.add(rss);
        }
        this.m_stunServer = this.pickStunServerInetAddress();
    }

    private void onSuccess(RankedStunServer m_stunServer2) {
        if (this.m_stunServer.successes < 5) {
            this.m_stunServer.successes++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IoSession connect(InetSocketAddress localAddress, InetSocketAddress stunServer) throws IOException {
        if (this.m_currentIoSession != null && this.m_currentIoSession.getRemoteAddress().equals(stunServer)) {
            return this.m_currentIoSession;
        }
        StunProtocolCodecFactory codecFactory = new StunProtocolCodecFactory();
        ProtocolCodecFilter stunFilter = new ProtocolCodecFilter((ProtocolCodecFactory)codecFactory);
        IoConnector connector = this.createConnector();
        connector.getFilterChain().addLast("stunFilter", (IoFilter)stunFilter);
        if (this.m_ioServiceListeners.isEmpty()) {
            LOG.debug("No service listeners for: {}", (Object)this.getClass().getSimpleName());
        }
        Collection<IoServiceListener> collection = this.m_ioServiceListeners;
        synchronized (collection) {
            for (IoServiceListener sl : this.m_ioServiceListeners) {
                connector.addListener(sl);
            }
        }
        LOG.debug("Connecting to: {}", (Object)stunServer);
        ConnectFuture cf = connector.connect((SocketAddress)stunServer, (SocketAddress)localAddress, this.m_ioHandler);
        LOG.debug("About to join");
        cf.join();
        LOG.debug("Connected to: {}", (Object)stunServer);
        IoSession session = cf.getSession();
        if (session == null) {
            throw new IOException("Could not get session with: " + stunServer);
        }
        this.m_sessions.add(session);
        this.m_currentIoSession = session;
        return session;
    }

    public InetSocketAddress getHostAddress() {
        return this.m_localAddress;
    }

    public InetAddress getStunServerAddress() {
        return this.m_stunServer.isa.getAddress();
    }

    protected void waitIfNoResponse(StunMessage request, long waitTime) {
        LOG.debug("Waiting " + waitTime + " milliseconds...");
        if (waitTime == 0L) {
            return;
        }
        if (!this.m_idsToResponses.containsKey(request.getTransactionId())) {
            try {
                LOG.debug("Actually waiting...");
                request.wait(waitTime);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupt", (Throwable)e);
            }
        }
    }

    public Object onTransactionFailed(StunMessage request, StunMessage response) {
        return this.notifyWaiters(request, response);
    }

    public Object onTransactionSucceeded(StunMessage request, StunMessage response) {
        return this.notifyWaiters(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object notifyWaiters(StunMessage request, StunMessage response) {
        StunMessage stunMessage = request;
        synchronized (stunMessage) {
            this.m_idsToResponses.put(request.getTransactionId(), response);
            request.notify();
        }
        return null;
    }

    @Override
    public final void addIoServiceListener(IoServiceListener serviceListener) {
        LOG.debug("Adding service listener for: {}", (Object)this);
        this.m_ioServiceListeners.add(serviceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.info("Closing sessions...");
        Collection<IoSession> collection = this.m_sessions;
        synchronized (collection) {
            for (IoSession session : this.m_sessions) {
                LOG.info("Closing: {}", (Object)session);
                session.close();
            }
        }
    }

    private IoConnector createConnector() {
        DatagramConnector connector = new DatagramConnector();
        DatagramConnectorConfig cfg = connector.getDefaultConfig();
        cfg.getSessionConfig().setReuseAddress(true);
        cfg.setThreadModel((ThreadModel)ExecutorThreadModel.getInstance((String)this.getClass().getSimpleName()));
        return connector;
    }

    public InetSocketAddress getServerReflexiveAddress() throws IOException {
        for (int i = 0; i < this.m_stunServers.size(); ++i) {
            LOG.info("Getting server reflexive address from: {}", (Object)this.m_stunServer);
            BindingRequest br = new BindingRequest();
            StunMessage message = this.write(br, this.m_stunServer.isa);
            StunMessageVisitorAdapter<InetSocketAddress> visitor = new StunMessageVisitorAdapter<InetSocketAddress>(){

                public InetSocketAddress visitBindingSuccessResponse(BindingSuccessResponse response) {
                    return response.getMappedAddress();
                }

                public InetSocketAddress visitBindingErrorResponse(BindingErrorResponse response) {
                    LOG.warn("Received Binding Error Response: " + response);
                    return null;
                }

                public InetSocketAddress visitConnectErrorMesssage(ConnectErrorStunMessage error) {
                    LOG.warn("Received ICMP error: {}", (Object)error);
                    return null;
                }
            };
            InetSocketAddress isa = (InetSocketAddress)message.accept((StunMessageVisitor)visitor);
            if (isa != null) {
                this.onSuccess(this.m_stunServer);
                this.m_stunServer = this.pickStunServerInetAddress();
                return isa;
            }
            this.onFailure(this.m_stunServer);
        }
        throw new IOException("Could not get server reflexive address!");
    }

    @Override
    public StunMessage write(BindingRequest request, InetSocketAddress remoteAddress) throws IOException {
        long rto = 100L;
        return this.write(request, remoteAddress, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StunMessage write(BindingRequest request, InetSocketAddress remoteAddress, long rto) throws IOException {
        IoSession session = this.connect(this.m_localAddress, remoteAddress);
        UUID id = request.getTransactionId();
        this.m_transactionTracker.addTransaction((StunMessage)request, (StunTransactionListener)this, this.m_localAddress, remoteAddress);
        long waitTime = 0L;
        BindingRequest bindingRequest = request;
        synchronized (bindingRequest) {
            for (int requests = 0; !this.m_idsToResponses.containsKey(id) && requests < 7; ++requests) {
                this.waitIfNoResponse((StunMessage)request, waitTime);
                session.write((Object)request);
                waitTime = 2L * waitTime + rto;
            }
            this.waitIfNoResponse((StunMessage)request, 1600L);
        }
        if (this.m_idsToResponses.containsKey(id)) {
            StunMessage response = this.m_idsToResponses.get(id);
            return response;
        }
        LOG.warn("Did not get response from: " + remoteAddress);
        return new NullStunMessage();
    }

    public InetSocketAddress getRelayAddress() {
        LOG.warn("Attempted to get a UDP relay!!");
        return null;
    }

    public boolean hostPortMapped() {
        return false;
    }

    private RankedStunServer pickStunServerInetAddress() throws IOException {
        return this.pickStunServerInetAddress(null);
    }

    private RankedStunServer pickStunServerInetAddress(InetSocketAddress skipAddress) throws IOException {
        if (this.m_stunServers.isEmpty()) {
            LOG.warn("Could not get STuN addresses!!");
            throw new IOException("No STUN addresses returned!");
        }
        if (skipAddress != null) {
            this.m_stunServers.remove(skipAddress);
        }
        RankedStunServer rss = this.m_stunServers.peek();
        return rss;
    }

    private class RankedStunServer
    implements Comparable<RankedStunServer> {
        private InetSocketAddress isa;
        private int successes;
        private int failures;

        private RankedStunServer(InetSocketAddress isa) throws DNSSECException {
            if (isa.isUnresolved() && StunClientConfig.isUseDnsSec()) {
                try {
                    this.isa = DnsSec.verify((InetSocketAddress)isa);
                }
                catch (IOException e) {
                    this.isa = isa;
                }
            } else {
                this.isa = isa;
            }
        }

        private int getScore() {
            return this.successes - this.failures;
        }

        public String toString() {
            return "RankedStunServer [isa=" + this.isa + " score=" + this.getScore() + "]";
        }

        @Override
        public int compareTo(RankedStunServer rss) {
            Integer score1 = rss.getScore();
            return score1.compareTo(this.getScore());
        }
    }
}

