/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.server;

import java.net.InetSocketAddress;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.StunMessageVisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunServerMessageVisitor
extends StunMessageVisitorAdapter<Object> {
    private final Logger LOG = LoggerFactory.getLogger(StunServerMessageVisitor.class);
    private final IoSession m_session;

    public StunServerMessageVisitor(IoSession session) {
        this.m_session = session;
    }

    public Object visitBindingRequest(BindingRequest binding) {
        this.LOG.debug("STUN server visiting binding request...");
        InetSocketAddress address = (InetSocketAddress)this.m_session.getRemoteAddress();
        UUID transactionId = binding.getTransactionId();
        BindingSuccessResponse response = new BindingSuccessResponse(transactionId.getRawBytes(), address);
        this.m_session.write((Object)response);
        return null;
    }
}

