/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.lastbamboo.common.stun.server.AbstractStunServer;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolCodecFilter;
import org.littleshoot.mina.filter.executor.ExecutorFilter;
import org.littleshoot.mina.transport.socket.nio.DatagramAcceptor;
import org.littleshoot.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.littleshoot.stun.stack.StunIoHandler;
import org.littleshoot.stun.stack.StunProtocolCodecFactory;
import org.littleshoot.stun.stack.message.StunMessageVisitorFactory;
import org.littleshoot.util.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpStunServer
extends AbstractStunServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ExecutorService threadPool = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory("UDP-STUN-Server-Thread-Pool-"));
    private final DatagramAcceptor acceptor = new DatagramAcceptor((Executor)threadPool);
    private InetSocketAddress bindAddress;

    public UdpStunServer(ProtocolCodecFactory codecFactory, IoHandler ioHandler, String threadName) {
        super(codecFactory, ioHandler, threadName);
    }

    public UdpStunServer(StunMessageVisitorFactory visitorFactory, String threadName) {
        this((ProtocolCodecFactory)new StunProtocolCodecFactory(), (IoHandler)new StunIoHandler(visitorFactory), threadName);
    }

    @Override
    protected void bind(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
        this.acceptor.addListener((IoServiceListener)this);
        DatagramAcceptorConfig config = this.acceptor.getDefaultConfig();
        config.setThreadModel(ThreadModel.MANUAL);
        config.getSessionConfig().setReuseAddress(true);
        ProtocolCodecFilter codecFilter = new ProtocolCodecFilter(this.codecFactory);
        config.getFilterChain().addLast("stunFilter", (IoFilter)codecFilter);
        config.getFilterChain().addLast("executor", (IoFilter)new ExecutorFilter((Executor)threadPool));
        try {
            this.acceptor.bind((SocketAddress)bindAddress, this.ioHandler, (IoServiceConfig)config);
            this.log.debug("Started STUN server!!");
        }
        catch (IOException e) {
            this.log.error("Could not bind server", (Throwable)e);
        }
    }

    @Override
    public void addIoServiceListener(IoServiceListener serviceListener) {
        this.acceptor.addListener(serviceListener);
    }

    @Override
    public void close() {
        this.log.info("Closing UDP STUN server on " + this.bindAddress);
        this.acceptor.unbindAll();
        this.acceptor.removeListener((IoServiceListener)this);
    }
}

