/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.turn.RemoteAddressAttribute;
import org.littleshoot.util.mina.MinaUtils;

public abstract class AbstractStunMessage
implements StunMessage {
    private static final Map<StunAttributeType, StunAttribute> EMPTY_MAP = Collections.emptyMap();
    private final UUID m_transactionId;
    private final Map<StunAttributeType, StunAttribute> m_attributes;
    private final int m_totalLength;
    private final int m_bodyLength;
    private final StunMessageType m_messageType;
    private static final int MAGIC_COOKIE = 554869826;
    private static final ByteBuffer MAGIC_COOKIE_BUF = ByteBuffer.allocate((int)4);

    public AbstractStunMessage(StunMessageType messageType) {
        this(AbstractStunMessage.createTransactionId(), messageType, EMPTY_MAP);
    }

    public AbstractStunMessage(StunMessageType messageType, Map<StunAttributeType, StunAttribute> attributes) {
        this(AbstractStunMessage.createTransactionId(), messageType, attributes);
    }

    public AbstractStunMessage(UUID transactionId, StunMessageType messageType) {
        this(transactionId, messageType, EMPTY_MAP);
    }

    public AbstractStunMessage(UUID transactionId, StunMessageType messageType, Map<StunAttributeType, StunAttribute> attributes) {
        this.m_transactionId = transactionId;
        this.m_attributes = attributes;
        this.m_bodyLength = AbstractStunMessage.calculateBodyLength(attributes);
        this.m_totalLength = this.m_bodyLength + 20;
        this.m_messageType = messageType;
    }

    private static UUID createTransactionId() {
        UUID id = UUID.randomUUID();
        byte[] idBytes = id.getRawBytes();
        ByteBuffer idBuf = ByteBuffer.wrap((byte[])idBytes);
        idBuf.limit(idBytes.length - 4);
        ByteBuffer newIdBuf = ByteBuffer.allocate((int)16);
        MinaUtils.putUnsignedInt((ByteBuffer)newIdBuf, (long)554869826L);
        newIdBuf.put(idBuf);
        newIdBuf.flip();
        return new UUID(MinaUtils.toByteArray((ByteBuffer)newIdBuf));
    }

    protected static Map<StunAttributeType, StunAttribute> createAttributes(StunAttribute ... attributes) {
        HashMap<StunAttributeType, StunAttribute> attributesMap = new HashMap<StunAttributeType, StunAttribute>();
        for (StunAttribute attribute : attributes) {
            attributesMap.put(attribute.getAttributeType(), attribute);
        }
        return attributesMap;
    }

    protected static Map<StunAttributeType, StunAttribute> createRemoteAddress(InetSocketAddress remoteAddress) {
        RemoteAddressAttribute att = new RemoteAddressAttribute(remoteAddress);
        return AbstractStunMessage.createAttributes(att);
    }

    private static int calculateBodyLength(Map<StunAttributeType, StunAttribute> attributesMap) {
        Collection<StunAttribute> attributes = attributesMap.values();
        int length = 0;
        for (StunAttribute attribute : attributes) {
            length += attribute.getTotalLength();
        }
        return length;
    }

    @Override
    public UUID getTransactionId() {
        return this.m_transactionId;
    }

    @Override
    public int getTotalLength() {
        return this.m_totalLength;
    }

    @Override
    public Map<StunAttributeType, StunAttribute> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public int getBodyLength() {
        return this.m_bodyLength;
    }

    @Override
    public StunMessageType getType() {
        return this.m_messageType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.m_attributes + " body length: " + this.m_bodyLength;
    }

    static {
        MAGIC_COOKIE_BUF.putInt(554869826);
    }
}

