/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.attributes.MappedAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingSuccessResponse
extends AbstractStunMessage {
    private final Logger LOG = LoggerFactory.getLogger(BindingSuccessResponse.class);
    private final InetSocketAddress m_mappedAddress;

    public BindingSuccessResponse(byte[] transactionId, InetSocketAddress address) {
        super(new UUID(transactionId), StunMessageType.BINDING_SUCCESS_RESPONSE, BindingSuccessResponse.createAttributes(address));
        this.m_mappedAddress = address;
    }

    public BindingSuccessResponse(UUID transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, StunMessageType.BINDING_SUCCESS_RESPONSE, attributes);
        this.m_mappedAddress = this.getAddress(attributes);
    }

    private InetSocketAddress getAddress(Map<StunAttributeType, StunAttribute> attributes) {
        MappedAddressAttribute mappedAddress = (MappedAddressAttribute)attributes.get((Object)StunAttributeType.MAPPED_ADDRESS);
        if (mappedAddress == null) {
            this.LOG.error("No mapped address in: " + attributes.values());
            return null;
        }
        return mappedAddress.getInetSocketAddress();
    }

    private static Map<StunAttributeType, StunAttribute> createAttributes(InetSocketAddress address) {
        HashMap<StunAttributeType, StunAttribute> attributes = new HashMap<StunAttributeType, StunAttribute>();
        MappedAddressAttribute attribute = new MappedAddressAttribute(address);
        attributes.put(StunAttributeType.MAPPED_ADDRESS, attribute);
        return attributes;
    }

    public InetSocketAddress getMappedAddress() {
        return this.m_mappedAddress;
    }

    @Override
    public <T> T accept(StunMessageVisitor<T> visitor) {
        return visitor.visitBindingSuccessResponse(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " with MAPPED ADDRESS: " + this.getMappedAddress();
    }
}

