/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.attributes;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.littleshoot.stun.stack.message.attributes.AbstractStunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;

public abstract class AbstractStunAddressAttribute
extends AbstractStunAttribute
implements StunAddressAttribute {
    private final InetSocketAddress m_inetSocketAddress;
    private final int m_addressFamily;

    public AbstractStunAddressAttribute(StunAttributeType attributeType, InetSocketAddress socketAddress) {
        super(attributeType, AbstractStunAddressAttribute.getBodyLength(socketAddress));
        this.m_inetSocketAddress = socketAddress;
        InetAddress address = socketAddress.getAddress();
        this.m_addressFamily = address instanceof Inet4Address ? 1 : 2;
    }

    private static int getBodyLength(InetSocketAddress address) {
        InetAddress ia = address.getAddress();
        if (ia instanceof Inet4Address) {
            return 8;
        }
        return 20;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.m_inetSocketAddress;
    }

    @Override
    public int getAddressFamily() {
        return this.m_addressFamily;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " for: " + this.m_inetSocketAddress;
    }
}

