/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.attributes;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.littleshoot.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressAttributeReader {
    private static final Logger LOG = LoggerFactory.getLogger(AddressAttributeReader.class);
    private static final short IPv4 = 1;
    private static final short IPv6 = 2;

    private AddressAttributeReader() {
    }

    public static InetSocketAddress readAddress(ByteBuffer body) throws IOException {
        int length;
        body.get();
        byte family = body.get();
        int port = body.getUnsignedShort();
        if (family == 1) {
            length = 4;
        } else if (family == 2) {
            length = 16;
        } else {
            LOG.error("Could not understand address family: " + family);
            throw new IOException("Could not understand address family: " + family);
        }
        byte[] addressBytes = new byte[length];
        body.get(addressBytes);
        InetAddress inetAddress = InetAddress.getByAddress(addressBytes);
        InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
        return socketAddress;
    }
}

