/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.attributes;

import java.util.HashMap;
import java.util.Map;

public enum StunAttributeType {
    MAPPED_ADDRESS(1),
    USERNAME(6),
    PASSWORD(7),
    MESSAGE_INTEGRITY(8),
    ERROR_CODE(9),
    UNKNOWN_ATTRIBUTES(10),
    REALM(20),
    NONCE(21),
    XOR_MAPPED_ADDRESS(32),
    FINGERPRINT(32801),
    SERVER(32802),
    ALTERNATE_SERVER(32803),
    REFRESH_INTERVAL(32804),
    RELAY_ADDRESS(22),
    REMOTE_ADDRESS(18),
    DATA(19),
    CONNECT_STAT(35),
    ICE_PRIORITY(36),
    ICE_USE_CANDIDATE(37),
    ICE_CONTROLLED(32809),
    ICE_CONTROLLING(32810);

    private static final Map<Integer, StunAttributeType> s_intsToEnums;
    private final int m_type;

    private StunAttributeType(int type) {
        this.m_type = type;
    }

    public int toInt() {
        return this.m_type;
    }

    public static StunAttributeType toType(int typeInt) {
        return s_intsToEnums.get(new Integer(typeInt));
    }

    static {
        s_intsToEnums = new HashMap<Integer, StunAttributeType>();
        for (StunAttributeType type : StunAttributeType.values()) {
            s_intsToEnums.put(new Integer(type.toInt()), type);
        }
    }
}

