/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.turn;

import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.turn.DataAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.RemoteAddressAttribute;

public abstract class AbstractStunDataMessage
extends AbstractStunMessage {
    private final InetSocketAddress m_remoteAddress;
    private final byte[] m_data;

    public AbstractStunDataMessage(UUID transactionId, StunMessageType messageType, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, messageType, attributes);
        this.m_remoteAddress = ((RemoteAddressAttribute)attributes.get((Object)StunAttributeType.REMOTE_ADDRESS)).getInetSocketAddress();
        this.m_data = ((DataAttribute)attributes.get((Object)StunAttributeType.DATA)).getData();
    }

    public AbstractStunDataMessage(StunMessageType messageType, byte[] data, InetSocketAddress remoteAddress) {
        super(messageType, AbstractStunDataMessage.createDataAttributes(data, remoteAddress));
        if (data.length > 65535) {
            throw new IllegalArgumentException("Data length must be smaller than: 65535 but is:" + data.length);
        }
        this.m_remoteAddress = remoteAddress;
        this.m_data = data;
    }

    private static Map<StunAttributeType, StunAttribute> createDataAttributes(byte[] data, InetSocketAddress remoteAddress) {
        RemoteAddressAttribute raa = new RemoteAddressAttribute(remoteAddress);
        DataAttribute da = new DataAttribute(data);
        return AbstractStunDataMessage.createAttributes(raa, da);
    }

    public final byte[] getData() {
        return this.m_data;
    }

    public final InetSocketAddress getRemoteAddress() {
        return this.m_remoteAddress;
    }
}

