/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.turn;

import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.attributes.ErrorCodeAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllocateErrorResponse
extends AbstractStunMessage {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());

    public AllocateErrorResponse(UUID transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, StunMessageType.ALLOCATE_ERROR_RESPONSE, attributes);
    }

    public AllocateErrorResponse(UUID transactionId, int errorCode, String reasonPhrase) {
        super(transactionId, StunMessageType.ALLOCATE_ERROR_RESPONSE, AllocateErrorResponse.createAttributes(errorCode, reasonPhrase));
    }

    private static Map<StunAttributeType, StunAttribute> createAttributes(int errorCode, String reasonPhrase) {
        ErrorCodeAttribute error = new ErrorCodeAttribute(errorCode, reasonPhrase);
        return AllocateErrorResponse.createAttributes(error);
    }

    public int getErrorCode() {
        Map<StunAttributeType, StunAttribute> attributes = this.getAttributes();
        ErrorCodeAttribute errorAttribute = (ErrorCodeAttribute)attributes.get((Object)StunAttributeType.ERROR_CODE);
        return errorAttribute.getErrorCode();
    }

    @Override
    public <T> T accept(StunMessageVisitor<T> visitor) {
        return visitor.visitAllocateErrorResponse(this);
    }
}

