/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.turn;

import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.turn.RemoteAddressAttribute;

public class ConnectRequest
extends AbstractStunMessage {
    private final InetSocketAddress m_remoteAddress;

    public ConnectRequest(UUID transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, StunMessageType.CONNECT_REQUEST, attributes);
        this.m_remoteAddress = ((RemoteAddressAttribute)attributes.get((Object)StunAttributeType.REMOTE_ADDRESS)).getInetSocketAddress();
    }

    public ConnectRequest(InetSocketAddress remoteAddress) {
        super(UUID.randomUUID(), StunMessageType.CONNECT_REQUEST, ConnectRequest.createRemoteAddress(remoteAddress));
        this.m_remoteAddress = remoteAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.m_remoteAddress;
    }

    @Override
    public <T> T accept(StunMessageVisitor<T> visitor) {
        return visitor.visitConnectRequest(this);
    }
}

