/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.transaction;

import com.google.common.base.Function;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.CanceledStunMessage;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.NullStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.turn.AllocateErrorResponse;
import org.littleshoot.stun.stack.message.turn.AllocateRequest;
import org.littleshoot.stun.stack.message.turn.AllocateSuccessResponse;
import org.littleshoot.stun.stack.message.turn.ConnectRequest;
import org.littleshoot.stun.stack.message.turn.ConnectionStatusIndication;
import org.littleshoot.stun.stack.message.turn.DataIndication;
import org.littleshoot.stun.stack.message.turn.SendIndication;
import org.littleshoot.stun.stack.transaction.StunClientTransaction;
import org.littleshoot.stun.stack.transaction.StunTransactionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunClientTransactionImpl
implements StunClientTransaction<StunMessage> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final StunMessage m_request;
    private long m_transactionTime = Long.MAX_VALUE;
    private List<StunTransactionListener> m_transactionListeners;
    private final long m_transactionStartTime;
    private final InetSocketAddress m_remoteAddress;

    public StunClientTransactionImpl(StunMessage request, List<StunTransactionListener> transactionListeners, InetSocketAddress remoteAddress) {
        this.m_request = request;
        this.m_transactionListeners = Collections.synchronizedList(transactionListeners);
        this.m_remoteAddress = remoteAddress;
        this.m_transactionStartTime = System.currentTimeMillis();
    }

    public StunClientTransactionImpl(StunMessage request, StunTransactionListener transactionListener, InetSocketAddress remoteAddress) {
        this.m_request = request;
        ArrayList<StunTransactionListener> listeners = new ArrayList<StunTransactionListener>();
        listeners.add(transactionListener);
        this.m_transactionListeners = Collections.synchronizedList(listeners);
        this.m_remoteAddress = remoteAddress;
        this.m_transactionStartTime = System.currentTimeMillis();
    }

    @Override
    public void addListener(StunTransactionListener listener) {
        this.m_transactionListeners.add(listener);
    }

    @Override
    public StunMessage getRequest() {
        return this.m_request;
    }

    @Override
    public long getTransactionTime() {
        return this.m_transactionTime;
    }

    @Override
    public InetSocketAddress getIntendedDestination() {
        return this.m_remoteAddress;
    }

    @Override
    public StunMessage visitBindingSuccessResponse(final BindingSuccessResponse response) {
        this.m_log.debug("Received success response");
        Function<StunTransactionListener, Boolean> success = new Function<StunTransactionListener, Boolean>(){

            public Boolean apply(StunTransactionListener listener) {
                listener.onTransactionSucceeded(StunClientTransactionImpl.this.m_request, response);
                return true;
            }
        };
        return this.notifyListeners(response, success);
    }

    @Override
    public StunMessage visitBindingErrorResponse(BindingErrorResponse response) {
        return this.notifyFailure(response);
    }

    @Override
    public StunMessage visitConnectErrorMesssage(ConnectErrorStunMessage message) {
        return this.notifyFailure(message);
    }

    private StunMessage notifyFailure(final StunMessage message) {
        Function<StunTransactionListener, Boolean> error = new Function<StunTransactionListener, Boolean>(){

            public Boolean apply(StunTransactionListener listener) {
                listener.onTransactionFailed(StunClientTransactionImpl.this.m_request, message);
                return true;
            }
        };
        return this.notifyListeners(message, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StunMessage notifyListeners(StunMessage response, Function<StunTransactionListener, Boolean> closure) {
        if (this.isSameTransaction(response)) {
            this.m_log.info("About to notify " + this.m_transactionListeners.size() + " listeners...");
            List<StunTransactionListener> list = this.m_transactionListeners;
            synchronized (list) {
                for (StunTransactionListener stl : this.m_transactionListeners) {
                    closure.apply((Object)stl);
                }
            }
            return response;
        }
        this.m_log.warn("Received response from different transaction.");
        return new NullStunMessage();
    }

    private boolean isSameTransaction(StunMessage response) {
        if (!this.m_request.getTransactionId().equals((Object)response.getTransactionId())) {
            this.m_log.error("Unexpected transaction ID.  Expected " + this.m_request.getTransactionId() + " but was " + response.getTransactionId());
            return false;
        }
        this.setTransactionTime();
        return true;
    }

    private void setTransactionTime() {
        this.m_transactionTime = System.currentTimeMillis() - this.m_transactionStartTime;
    }

    @Override
    public StunMessage visitBindingRequest(BindingRequest binding) {
        return null;
    }

    @Override
    public StunMessage visitAllocateRequest(AllocateRequest request) {
        return null;
    }

    @Override
    public StunMessage visitDataIndication(DataIndication data) {
        return null;
    }

    @Override
    public StunMessage visitSendIndication(SendIndication request) {
        return null;
    }

    @Override
    public StunMessage visitAllocateSuccessResponse(AllocateSuccessResponse response) {
        return null;
    }

    @Override
    public StunMessage visitAllocateErrorResponse(AllocateErrorResponse response) {
        return null;
    }

    @Override
    public StunMessage visitConnectRequest(ConnectRequest request) {
        this.m_log.error("Client received connect request");
        return null;
    }

    @Override
    public StunMessage visitConnectionStatusIndication(ConnectionStatusIndication indication) {
        return null;
    }

    @Override
    public StunMessage visitNullMessage(NullStunMessage message) {
        return message;
    }

    @Override
    public StunMessage visitCanceledMessage(CanceledStunMessage message) {
        return message;
    }
}

