/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.SystemUtils;
import org.lastbamboo.common.turn.client.TurnClient;
import org.lastbamboo.common.turn.client.TurnClientConfig;
import org.lastbamboo.common.turn.client.TurnClientIoHandler;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.lastbamboo.common.turn.client.TurnStunMessageMapperImpl;
import org.littleshoot.dnssec4j.DNSSECException;
import org.littleshoot.dnssec4j.DnsSec;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.CloseFuture;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExecutorThreadModel;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoFilterAdapter;
import org.littleshoot.mina.common.IoFuture;
import org.littleshoot.mina.common.IoFutureListener;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.RuntimeIOException;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolCodecFilter;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.mina.transport.socket.nio.SocketConnector;
import org.littleshoot.mina.transport.socket.nio.SocketConnectorConfig;
import org.littleshoot.stun.stack.StunMessageDecoder;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorAdapter;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatus;
import org.littleshoot.stun.stack.message.turn.AllocateErrorResponse;
import org.littleshoot.stun.stack.message.turn.AllocateRequest;
import org.littleshoot.stun.stack.message.turn.AllocateSuccessResponse;
import org.littleshoot.stun.stack.message.turn.ConnectRequest;
import org.littleshoot.stun.stack.message.turn.ConnectionStatusIndication;
import org.littleshoot.stun.stack.message.turn.DataIndication;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.RuntimeIoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTurnClient
extends StunMessageVisitorAdapter<StunMessage>
implements TurnClient,
IoServiceListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private InetSocketAddress m_stunServerAddress;
    private IoSession m_ioSession;
    private InetSocketAddress m_relayAddress;
    private InetSocketAddress m_mappedAddress;
    private boolean m_receivedAllocateResponse;
    private final TurnClientListener m_turnClientListener;
    private final ProtocolCodecFactory m_dataCodecFactory;
    private int m_totalReadDataBytes;
    private int m_totalReadRawDataBytes;
    private final AtomicBoolean m_connected = new AtomicBoolean(false);
    private final SocketConnector m_connector = new SocketConnector();
    private final CandidateProvider<InetSocketAddress> m_candidateProvider;

    public TcpTurnClient(TurnClientListener clientListener, CandidateProvider<InetSocketAddress> candidateProvider, ProtocolCodecFactory codecFactory) {
        this.m_turnClientListener = clientListener;
        this.m_candidateProvider = candidateProvider;
        this.m_dataCodecFactory = codecFactory;
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.m_connected.get()) {
            throw new IllegalArgumentException("Already connected...");
        }
        Collection candidates = this.m_candidateProvider.getCandidates();
        this.m_log.info("Attempting connections to: {}", (Object)candidates);
        for (InetSocketAddress serverAddress : candidates) {
            this.connect(serverAddress, null);
            AtomicBoolean atomicBoolean = this.m_connected;
            synchronized (atomicBoolean) {
                try {
                    this.m_connected.wait(30000L);
                }
                catch (InterruptedException e) {
                    this.m_log.error("Interrupted while waiting", (Throwable)e);
                }
            }
            if (!this.isConnected()) continue;
            this.m_log.debug("Connected to: {}", (Object)serverAddress);
            break;
        }
        if (!this.isConnected()) {
            this.m_log.error("Could not connect or did not get allocate response");
            this.close();
            throw new IOException("Could not connect to any of: " + candidates);
        }
    }

    private void connect(InetSocketAddress unverifiedStunServerAddress, InetSocketAddress localAddress) throws IOException {
        InetSocketAddress stunServerAddress;
        if (TurnClientConfig.isUseDnsSec()) {
            try {
                stunServerAddress = DnsSec.verify((InetSocketAddress)unverifiedStunServerAddress);
            }
            catch (DNSSECException e) {
                throw new IOException("DNSSEC verification error", e);
            }
        } else {
            stunServerAddress = unverifiedStunServerAddress;
        }
        final StunMessageDecoder decoder = new StunMessageDecoder();
        IoFilterAdapter turnFilter = new IoFilterAdapter(){

            public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
                nextFilter.filterWrite(session, writeRequest);
            }

            public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
                ByteBuffer in = (ByteBuffer)message;
                ProtocolDecoderOutput out = new ProtocolDecoderOutput(){

                    public void flush() {
                    }

                    public void write(Object msg) {
                        StunMessage stunMessage = (StunMessage)msg;
                        stunMessage.accept((StunMessageVisitor)TcpTurnClient.this);
                    }
                };
                decoder.decode(session, in, out);
            }
        };
        ProtocolCodecFilter dataFilter = new ProtocolCodecFilter(this.m_dataCodecFactory);
        this.m_connector.getFilterChain().addLast("stunFilter", (IoFilter)turnFilter);
        this.m_connector.getFilterChain().addLast("dataFilter", (IoFilter)dataFilter);
        this.m_connector.addListener((IoServiceListener)this);
        this.m_stunServerAddress = stunServerAddress;
        SocketConnectorConfig config = new SocketConnectorConfig();
        if (SystemUtils.IS_OS_WINDOWS_VISTA) {
            config.getSessionConfig().setKeepAlive(false);
        } else {
            config.getSessionConfig().setKeepAlive(true);
        }
        config.getSessionConfig().setReuseAddress(true);
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)("TCP-TURN-Client-" + this.hashCode()));
        config.setThreadModel((ThreadModel)threadModel);
        this.m_log.info("Connection to STUN server here: {}", (Object)this.m_stunServerAddress);
        TurnClientIoHandler ioHandler = new TurnClientIoHandler((StunMessageVisitor<StunMessage>)this);
        ConnectFuture connectFuture = localAddress == null ? this.m_connector.connect((SocketAddress)this.m_stunServerAddress, (IoHandler)ioHandler, (IoServiceConfig)config) : this.m_connector.connect((SocketAddress)this.m_stunServerAddress, (SocketAddress)localAddress, (IoHandler)ioHandler, (IoServiceConfig)config);
        IoFutureListener futureListener = new IoFutureListener(){

            public void operationComplete(IoFuture ioFuture) {
                if (!ioFuture.isReady()) {
                    TcpTurnClient.this.m_log.warn("Future not ready?");
                    return;
                }
                try {
                    TcpTurnClient.this.m_ioSession = ioFuture.getSession();
                }
                catch (RuntimeIOException e) {
                    TcpTurnClient.this.m_log.warn("Could not connect to TURN server at: " + stunServerAddress, (Throwable)e);
                    return;
                }
                if (TcpTurnClient.this.m_ioSession == null || !TcpTurnClient.this.m_ioSession.isConnected()) {
                    TcpTurnClient.this.m_log.error("Could not create session");
                    throw new RuntimeIoException("Could not get session");
                }
                TurnStunMessageMapperImpl mapper = new TurnStunMessageMapperImpl();
                TcpTurnClient.this.m_ioSession.setAttribute("REMOTE_ADDRESS_MAP", (Object)mapper);
                AllocateRequest msg = new AllocateRequest();
                TcpTurnClient.this.m_log.debug("Sending allocate request to write handler...");
                TcpTurnClient.this.m_ioSession.write((Object)msg);
            }
        };
        connectFuture.addListener(futureListener);
        connectFuture.join();
    }

    @Override
    public void close() {
        this.m_log.debug("Closing TCP TURN client.");
        if (this.m_ioSession != null) {
            CloseFuture closeFuture = this.m_ioSession.close();
            closeFuture.join();
        }
    }

    @Override
    public void sendConnectRequest(InetSocketAddress remoteAddress) {
        ConnectRequest request = new ConnectRequest(remoteAddress);
        this.m_ioSession.write((Object)request);
    }

    @Override
    public InetSocketAddress getRelayAddress() {
        return this.m_relayAddress;
    }

    @Override
    public InetSocketAddress getMappedAddress() {
        return this.m_mappedAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StunMessage visitAllocateSuccessResponse(AllocateSuccessResponse response) {
        this.m_log.debug("Got successful allocate response: {}", (Object)response);
        this.m_relayAddress = response.getRelayAddress();
        this.m_mappedAddress = response.getMappedAddress();
        this.m_receivedAllocateResponse = true;
        this.m_connected.set(true);
        AtomicBoolean atomicBoolean = this.m_connected;
        synchronized (atomicBoolean) {
            this.m_connected.notifyAll();
        }
        return null;
    }

    public StunMessage visitAllocateErrorResponse(AllocateErrorResponse response) {
        this.m_log.warn("Received an Allocate Response error from the server: " + response.getAttributes());
        this.m_ioSession.close();
        return null;
    }

    public StunMessage visitConnectionStatusIndication(ConnectionStatusIndication indication) {
        this.m_log.debug("Visiting connection status message: {}", (Object)indication);
        ConnectionStatus status = indication.getConnectionStatus();
        InetSocketAddress remoteAddress = indication.getRemoteAddress();
        switch (status) {
            case CLOSED: {
                this.m_log.debug("Got connection closed from: " + remoteAddress);
                this.m_turnClientListener.onRemoteAddressClosed(remoteAddress);
                break;
            }
            case ESTABLISHED: {
                this.m_log.debug("Connection established from: " + remoteAddress);
                this.m_turnClientListener.onRemoteAddressOpened(remoteAddress, this.m_ioSession);
                break;
            }
            case LISTEN: {
                this.m_log.debug("Got server listening for incoming data from: " + remoteAddress);
            }
        }
        return null;
    }

    public StunMessage visitDataIndication(DataIndication data) {
        this.m_log.debug("Visiting Data Indication message: {}", (Object)data);
        this.m_totalReadDataBytes += data.getTotalLength();
        this.m_totalReadRawDataBytes += data.getData().length;
        InetSocketAddress remoteAddress = data.getRemoteAddress();
        try {
            this.m_turnClientListener.onData(remoteAddress, this.m_ioSession, data.getData());
        }
        catch (Exception e) {
            this.m_log.error("Could not process data: {}", (Object)data, (Object)e);
        }
        return null;
    }

    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.m_log.debug("Service activated...");
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.m_log.debug("Service deactivated...");
    }

    public void sessionCreated(IoSession session) {
        this.m_log.debug("Session created...");
    }

    public void sessionDestroyed(IoSession session) {
        this.m_log.debug("Session destroyed...");
        if (this.m_receivedAllocateResponse) {
            this.m_receivedAllocateResponse = false;
            this.m_connected.set(false);
        }
        this.m_turnClientListener.close();
    }

    @Override
    public InetAddress getStunServerAddress() {
        return this.m_stunServerAddress.getAddress();
    }

    public InetSocketAddress getHostAddress() {
        return (InetSocketAddress)this.m_ioSession.getLocalAddress();
    }

    public InetSocketAddress getServerReflexiveAddress() {
        return this.getMappedAddress();
    }

    public StunMessage write(BindingRequest request, InetSocketAddress remoteAddress) {
        this.m_log.error("Unsupported!!!!!!!");
        throw new IllegalStateException("Not implemented.");
    }

    public StunMessage write(BindingRequest request, InetSocketAddress remoteAddress, long rto) {
        this.m_log.error("Unsupported!!!!!!!");
        throw new IllegalStateException("Not implemented.");
    }

    @Override
    public boolean isConnected() {
        return this.m_connected.get();
    }

    public boolean hostPortMapped() {
        return false;
    }

    public void addIoServiceListener(IoServiceListener serviceListener) {
        if (serviceListener == null) {
            throw new NullPointerException("Null listener");
        }
        this.m_connector.addListener(serviceListener);
    }
}

