/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.client;

import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.util.SessionUtil;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnClientIoHandler
extends IoHandlerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final StunMessageVisitor<StunMessage> visitor;

    public TurnClientIoHandler(StunMessageVisitor<StunMessage> visitor) {
        this.visitor = visitor;
    }

    public void messageReceived(IoSession session, Object message) {
        StunMessage vsm = (StunMessage)message;
        vsm.accept(this.visitor);
    }

    public void sessionClosed(IoSession session) {
    }

    public void sessionCreated(IoSession session) {
        SessionUtil.initialize((IoSession)session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.LOG.debug("Session idle...closing TURN connection to server...");
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.LOG.warn("Caught exception", cause);
    }
}

