/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.client;

import java.net.InetSocketAddress;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.turn.client.TurnStunMessageMapper;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolEncoderOutput;
import org.littleshoot.stun.stack.encoder.StunMessageEncoder;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.CanceledStunMessage;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.NullStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.turn.AllocateErrorResponse;
import org.littleshoot.stun.stack.message.turn.AllocateRequest;
import org.littleshoot.stun.stack.message.turn.AllocateSuccessResponse;
import org.littleshoot.stun.stack.message.turn.ConnectRequest;
import org.littleshoot.stun.stack.message.turn.ConnectionStatusIndication;
import org.littleshoot.stun.stack.message.turn.DataIndication;
import org.littleshoot.stun.stack.message.turn.SendIndication;
import org.littleshoot.util.mina.DemuxableProtocolEncoder;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnStunProtocolEncoder
implements DemuxableProtocolEncoder {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());

    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object msg, ProtocolEncoderOutput out) throws Exception {
        this.m_log.debug("Encoding TURN/STUN message: {}", msg);
        StunMessage stunMessage = (StunMessage)msg;
        TurnStunMessageMapper mapper = (TurnStunMessageMapper)session.getAttribute("REMOTE_ADDRESS_MAP");
        SendIndicationStunMessageVisitor visitor = new SendIndicationStunMessageVisitor(out, mapper);
        stunMessage.accept((StunMessageVisitor)visitor);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private final class SendIndicationStunMessageVisitor
    implements StunMessageVisitor<ByteBuffer> {
        private final ProtocolEncoderOutput m_out;
        private final TurnStunMessageMapper m_mapper;

        private SendIndicationStunMessageVisitor(ProtocolEncoderOutput out, TurnStunMessageMapper mapper) {
            this.m_out = out;
            this.m_mapper = mapper;
        }

        private void wrapInSendIndication(StunMessage msg) {
            StunMessageEncoder encoder = new StunMessageEncoder();
            ByteBuffer buf = encoder.encode(msg);
            InetSocketAddress remoteAddress = this.m_mapper.get(msg);
            if (remoteAddress == null) {
                TurnStunProtocolEncoder.this.m_log.warn("No matching transaction ID for: {} in {}", (Object)msg, (Object)this.m_mapper);
                return;
            }
            byte[] bytes = MinaUtils.toByteArray((ByteBuffer)buf);
            TurnStunProtocolEncoder.this.m_log.debug("Sending TCP framed data of length: {}", (Object)bytes.length);
            SendIndication indication = new SendIndication(remoteAddress, bytes);
            ByteBuffer indicationBuf = encoder.encode((StunMessage)indication);
            this.m_out.write(indicationBuf);
        }

        private void noWrap(StunMessage msg) {
            StunMessageEncoder encoder = new StunMessageEncoder();
            ByteBuffer buf = encoder.encode(msg);
            if (buf == null) {
                TurnStunProtocolEncoder.this.m_log.error("Null buffer for message: {}", (Object)msg);
            } else {
                this.m_out.write(buf);
            }
        }

        public ByteBuffer visitAllocateRequest(AllocateRequest request) {
            this.noWrap((StunMessage)request);
            return null;
        }

        public ByteBuffer visitBindingErrorResponse(BindingErrorResponse response) {
            this.wrapInSendIndication((StunMessage)response);
            return null;
        }

        public ByteBuffer visitBindingRequest(BindingRequest binding) {
            this.wrapInSendIndication((StunMessage)binding);
            return null;
        }

        public ByteBuffer visitBindingSuccessResponse(BindingSuccessResponse response) {
            InetSocketAddress remoteAddress = this.m_mapper.get((StunMessage)response);
            if (remoteAddress == null) {
                TurnStunProtocolEncoder.this.m_log.warn("No matching transaction ID for: {}", (Object)response);
                return null;
            }
            UUID transactionId = response.getTransactionId();
            BindingSuccessResponse turnResponse = new BindingSuccessResponse(transactionId.getRawBytes(), remoteAddress);
            this.wrapInSendIndication((StunMessage)turnResponse);
            return null;
        }

        public ByteBuffer visitCanceledMessage(CanceledStunMessage message) {
            this.noWrap((StunMessage)message);
            return null;
        }

        public ByteBuffer visitSendIndication(SendIndication request) {
            TurnStunProtocolEncoder.this.m_log.debug("Writing send indication...");
            this.noWrap((StunMessage)request);
            return null;
        }

        public ByteBuffer visitAllocateErrorResponse(AllocateErrorResponse response) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)response);
            return null;
        }

        public ByteBuffer visitAllocateSuccessResponse(AllocateSuccessResponse response) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)response);
            return null;
        }

        public ByteBuffer visitConnectErrorMesssage(ConnectErrorStunMessage message) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)message);
            return null;
        }

        public ByteBuffer visitConnectRequest(ConnectRequest request) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)request);
            return null;
        }

        public ByteBuffer visitConnectionStatusIndication(ConnectionStatusIndication indication) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)indication);
            return null;
        }

        public ByteBuffer visitDataIndication(DataIndication data) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)data);
            return null;
        }

        public ByteBuffer visitNullMessage(NullStunMessage message) {
            TurnStunProtocolEncoder.this.m_log.warn("Unexpected message: {}", (Object)message);
            return null;
        }
    }
}

