/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.http.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.lastbamboo.common.turn.client.TurnLocalIoHandler;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExecutorThreadModel;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.transport.socket.nio.SocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDataFeeder
implements TurnClientListener,
IoServiceListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Map<InetSocketAddress, IoSession> m_addressesToSessions = new ConcurrentHashMap<InetSocketAddress, IoSession>();
    private final InetSocketAddress m_serverAddress;

    public ServerDataFeeder(InetSocketAddress serverAddress) {
        this.m_serverAddress = serverAddress;
    }

    public void onData(InetSocketAddress remoteAddress, IoSession session, byte[] data) {
        this.m_log.debug("Received data message");
        IoSession localSession = this.onRemoteAddressOpened(remoteAddress, session);
        ByteBuffer dataBuf = ByteBuffer.wrap((byte[])data);
        localSession.write((Object)dataBuf);
        this.m_log.debug("Local bytes written: {}", (Object)localSession.getWrittenBytes());
    }

    public IoSession onRemoteAddressOpened(InetSocketAddress remoteAddress, IoSession ioSession) {
        if (this.m_addressesToSessions.containsKey(remoteAddress)) {
            this.m_log.debug("Using existing local connection to: {}", (Object)remoteAddress);
            return this.m_addressesToSessions.get(remoteAddress);
        }
        this.m_log.debug("Opening new local socket for remote address: {}", (Object)remoteAddress);
        SocketConnector connector = new SocketConnector();
        connector.addListener((IoServiceListener)this);
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)"TCP-TURN-Local-Socket");
        connector.getDefaultConfig().setThreadModel((ThreadModel)threadModel);
        TurnLocalIoHandler ioHandler = new TurnLocalIoHandler(ioSession, remoteAddress);
        ConnectFuture ioFuture = connector.connect((SocketAddress)this.m_serverAddress, (IoHandler)ioHandler);
        ioFuture.join(10000L);
        IoSession session = ioFuture.getSession();
        if (session == null || !session.isConnected()) {
            this.m_log.error("Could not connect to server: {}", (Object)this.m_serverAddress);
            return null;
        }
        this.m_log.debug("Connected to server: {}", (Object)this.m_serverAddress);
        this.m_addressesToSessions.put(remoteAddress, session);
        return session;
    }

    public void onRemoteAddressClosed(InetSocketAddress remoteAddress) {
        if (!this.m_addressesToSessions.containsKey(remoteAddress)) {
            this.m_log.warn("We don't know about the remote address: {}", (Object)remoteAddress);
            this.m_log.warn("Address not in: {}", this.m_addressesToSessions.keySet());
        } else {
            this.m_log.debug("Closing connection to local HTTP server...");
            IoSession session = this.m_addressesToSessions.remove(remoteAddress);
            session.close();
        }
    }

    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
    }

    public void sessionCreated(IoSession session) {
    }

    public void sessionDestroyed(IoSession session) {
        for (Map.Entry<InetSocketAddress, IoSession> entry : this.m_addressesToSessions.entrySet()) {
            if (!entry.getValue().equals(session)) continue;
            InetSocketAddress key = entry.getKey();
            this.m_log.debug("Removing session for address: {}", (Object)key);
            this.m_addressesToSessions.remove(key);
            return;
        }
        this.m_log.warn("Did not find session:\n{}\nin:{}", (Object)session, this.m_addressesToSessions);
    }

    public void close() {
        Collection<IoSession> sessions = this.m_addressesToSessions.values();
        for (IoSession curSession : sessions) {
            curSession.close();
        }
        this.m_addressesToSessions.clear();
    }
}

