/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import org.littleshoot.util.Unsigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteBufferUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferUtils.class);
    private static final byte[] highDigits;
    private static final byte[] lowDigits;

    public static ByteBuffer[] toArray(byte[] byteArray, int sizeLimit) {
        int numBufs = (int)Math.ceil((double)byteArray.length / (double)sizeLimit);
        ByteBuffer[] bufs = new ByteBuffer[numBufs];
        int byteIndex = 0;
        for (int i = 0; i < numBufs; ++i) {
            int remaining = byteArray.length - byteIndex;
            int numBytes = remaining < sizeLimit ? remaining : sizeLimit;
            bufs[i] = ByteBuffer.wrap(byteArray, byteIndex, numBytes);
            byteIndex += sizeLimit;
        }
        return bufs;
    }

    public static Collection<ByteBuffer> split(ByteBuffer buffer, int chunkSize) {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        int limit = buffer.limit();
        int totalSent = 0;
        while (totalSent + chunkSize < limit) {
            LOG.trace("Setting limit to: " + (totalSent + chunkSize));
            buffer.limit(totalSent + chunkSize);
            buffers.add(ByteBufferUtils.createBuffer(buffer));
            totalSent += chunkSize;
        }
        buffer.limit(limit);
        buffers.add(ByteBufferUtils.createBuffer(buffer));
        return buffers;
    }

    private static ByteBuffer createBuffer(ByteBuffer buffer) {
        ByteBuffer data = ByteBuffer.allocate(buffer.limit() - buffer.position());
        LOG.trace("Created buffer with capacity: " + data.capacity());
        data.put(buffer);
        data.rewind();
        return data;
    }

    public static ByteBuffer combine(Collection<ByteBuffer> buffers) {
        ByteBuffer buf = ByteBuffer.allocate(ByteBufferUtils.remaining(buffers));
        for (ByteBuffer curBuf : buffers) {
            buf.put(curBuf);
        }
        buf.flip();
        return buf;
    }

    public static int remaining(Collection<ByteBuffer> buffers) {
        int remaining = 0;
        for (ByteBuffer buf : buffers) {
            remaining += buf.remaining();
        }
        return remaining;
    }

    public static void logBufferToWrite(ByteBuffer buffer) {
        LOG.trace("Writing: ");
        LOG.trace(ByteBufferUtils.toString(buffer));
    }

    public static String toString(ByteBuffer buffer) {
        int position = buffer.position();
        int limit = buffer.limit();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        String dataString = new String(data);
        buffer.position(position);
        buffer.limit(limit);
        return dataString;
    }

    public static byte[] readBytes16(ByteBuffer buf) {
        int length = Unsigned.getUnsignedShort(buf);
        byte[] bytes = new byte[length];
        try {
            buf.get(bytes);
        }
        catch (BufferUnderflowException e) {
            LOG.error("Underflow. Expected " + length + " bytes", (Throwable)e);
            throw e;
        }
        return bytes;
    }

    public static String getHexdump(ByteBuffer in) {
        int size = in.remaining();
        if (size == 0) {
            return "ByteBufferUtils::getHexdump buffer is empty";
        }
        StringBuilder out = new StringBuilder(in.remaining() * 3 - 1);
        int mark = in.position();
        int byteValue = in.get() & 0xFF;
        out.append((char)highDigits[byteValue]);
        out.append((char)lowDigits[byteValue]);
        --size;
        while (size > 0) {
            out.append(' ');
            byteValue = in.get() & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            --size;
        }
        in.position(mark);
        return out.toString();
    }

    public static byte[] toRawBytes(ByteBuffer buf) {
        int mark = buf.position();
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        buf.position(mark);
        return bytes;
    }

    static {
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] high = new byte[256];
        byte[] low = new byte[256];
        for (int i = 0; i < 256; ++i) {
            high[i] = digits[i >>> 4];
            low[i] = digits[i & 0xF];
        }
        highDigits = high;
        lowDigits = low;
    }
}

