/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.littleshoot.util.DecryptingInputStream;
import org.littleshoot.util.EncryptingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherSocket
extends Socket {
    private static final Logger LOG = LoggerFactory.getLogger(CipherSocket.class);
    private final byte[] writeKey;
    private final byte[] readKey;
    private final Socket sock;
    private int storedTimeout = 0;
    private final long startTime = System.currentTimeMillis();

    public CipherSocket(Socket sock, byte[] writeKey, byte[] readKey) {
        LOG.info("Creating new cipher socket!!");
        if (writeKey == null) {
            LOG.error("Write key can't be null!");
            throw new NullPointerException("Write key can't be null!");
        }
        if (readKey == null) {
            LOG.error("Read key can't be null!");
            throw new NullPointerException("Read key can't be null!");
        }
        this.sock = sock;
        this.writeKey = writeKey;
        this.readKey = readKey;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new EncryptingOutputStream(this.writeKey, this.sock.getOutputStream());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new DecryptingInputStream(this.readKey, this.sock.getInputStream());
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.sock.bind(bindpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        LOG.info("CLOSING SOCKET!!");
        this.sock.close();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.sock.connect(endpoint, timeout);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.sock.connect(endpoint);
    }

    @Override
    public SocketChannel getChannel() {
        return this.sock.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.sock.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.sock.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.sock.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.sock.getOOBInline();
    }

    @Override
    public int getPort() {
        return this.sock.getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.sock.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.sock.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.sock.getReuseAddress();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.sock.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.sock.getSoLinger();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.sock.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.sock.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.sock.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.sock.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.sock.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.sock.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.sock.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.sock.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.sock.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.sock.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.sock.setOOBInline(on);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.sock.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.sock.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.sock.setReuseAddress(on);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.sock.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.sock.setSoLinger(on, linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.storedTimeout = timeout;
        this.sock.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.sock.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.sock.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.sock.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.sock.shutdownOutput();
    }

    @Override
    public String toString() {
        return "CipherSocket [sock=" + this.sock + "]\n" + "SO_TIMEOUT: " + this.storedTimeout + "\n" + "UPTIME: " + (System.currentTimeMillis() - this.startTime) / 1000L;
    }
}

