/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtils.class);
    private static final boolean IS_PRO = true;
    public static final int FREE_RESULT_LIMIT = 40;
    public static final String LIMEWIRE_ENABLED_KEY = "LIMEWIRE_ENABLED";
    public static final String SEEDING_ENABLED_KEY = "SEEDING_ENABLED";
    public static final String UPLOAD_SPEED_KEY = "UPLOAD_SPEED";
    private static final String DEFAULT_CIPHER = "AES";
    private static final KeyGenerator keyGenerator;
    private static final SecureRandom secureRandom;
    private static Properties littleShootProps;
    private static final int SIZE_LIMIT;

    private CommonUtils() {
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static void threadedCopy(final InputStream is, final OutputStream os, String threadName) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (IOException e) {
                    LOG.info("Exception on copy. Hung up?", (Throwable)e);
                }
            }
        };
        Thread t = new Thread(runner, threadName);
        t.setDaemon(true);
        t.start();
    }

    public static File getDataDir() {
        File dir = SystemUtils.IS_OS_WINDOWS ? new File(System.getenv("APPDATA"), "LittleShoot") : (SystemUtils.IS_OS_MAC_OSX ? new File("/Library/Application\\ Support/LittleShoot") : CommonUtils.getLittleShootDir());
        if (dir.isDirectory() || dir.mkdirs()) {
            return dir;
        }
        LOG.error("Not a directory: {}", (Object)dir);
        return new File(SystemUtils.USER_HOME, ".littleshoot");
    }

    public static boolean isPro() {
        return true;
    }

    public static File getLittleShootDir() {
        File lsDir = new File(SystemUtils.USER_HOME, ".littleshoot");
        if (!lsDir.isDirectory() && !lsDir.mkdirs()) {
            LOG.error("Could not make .littleshoot directory!");
        }
        return lsDir;
    }

    public static boolean isTrue(String varName) {
        String prop = System.getProperty(varName);
        return CommonUtils.isStringTrue(prop);
    }

    public static boolean isPropertyTrue(String key) {
        Properties props = CommonUtils.getProps();
        String prop = props.getProperty(key);
        return CommonUtils.isStringTrue(prop);
    }

    public static boolean isStringTrue(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        return str.trim().equalsIgnoreCase("true");
    }

    public static File getPropsFile() {
        return new File(CommonUtils.getLittleShootDir(), "littleshoot.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProps() {
        Properties properties;
        if (littleShootProps != null) {
            return littleShootProps;
        }
        File propsFile = CommonUtils.getPropsFile();
        if (!propsFile.isFile()) {
            try {
                propsFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error("Could not create props file?", (Throwable)e);
            }
        }
        littleShootProps = new Properties();
        FileReader fr = null;
        try {
            fr = new FileReader(propsFile);
            littleShootProps.load(fr);
            properties = littleShootProps;
        }
        catch (IOException e) {
            Properties properties2;
            try {
                LOG.error("Should not happen", (Throwable)e);
                littleShootProps = null;
                properties2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)fr);
            return properties2;
        }
        IOUtils.closeQuietly((Reader)fr);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProps(Properties props) {
        File file = CommonUtils.getPropsFile();
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            props.store(fw, "LittleShoot Properties File");
        }
        catch (IOException e) {
            try {
                LOG.error("Could not write props!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw);
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    public static void setProperty(String key, String value) {
        Properties props = CommonUtils.getProps();
        props.setProperty(key, value);
        CommonUtils.saveProps(props);
    }

    public static String nativeCall(String fullCommand) {
        return CommonUtils.nativeCall(StringUtils.split((String)fullCommand));
    }

    public static String nativeCall(String ... commands) {
        LOG.info("Running '{}'", Arrays.asList(commands));
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            Process process = pb.start();
            InputStream is = process.getInputStream();
            String data = IOUtils.toString((InputStream)is);
            LOG.info("Completed native call: '{}'\nResponse: '" + data + "'", Arrays.asList(commands));
            return data;
        }
        catch (IOException e) {
            LOG.error("Error running commands: " + Arrays.asList(commands), (Throwable)e);
            return "";
        }
    }

    public static byte[] combine(byte[] ... arrays) {
        return CommonUtils.combine(Arrays.asList(arrays));
    }

    public static byte[] combine(Collection<byte[]> arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] joinedArray = new byte[length];
        int position = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, joinedArray, position, array.length);
            position += array.length;
        }
        return joinedArray;
    }

    public static byte[] encode(byte[] key, byte[] data, int off, int len) {
        if (len < SIZE_LIMIT) {
            return CommonUtils.encodeSingleMessage(key, data, off, len);
        }
        int numArrays = (int)Math.ceil((double)data.length / (double)SIZE_LIMIT);
        ArrayList<byte[]> arrays = new ArrayList<byte[]>(numArrays);
        int index = 0;
        for (int i = 0; i < numArrays; ++i) {
            int remaining = data.length - index;
            int size = remaining < SIZE_LIMIT ? remaining : SIZE_LIMIT;
            byte[] msg = CommonUtils.encodeSingleMessage(key, data, index, size);
            arrays.add(msg);
            index += size;
        }
        return CommonUtils.combine(arrays);
    }

    public static byte[] encodeSingleMessage(byte[] key, byte[] data, int off, int len) {
        Mac mac;
        int written;
        SecretKeySpec skeySpec = new SecretKeySpec(key, DEFAULT_CIPHER);
        ByteBuffer dataBuf = ByteBuffer.wrap(data, off, len);
        int cipherTextLength = len > 7 ? len * 2 : 16;
        byte[] cipherTextBytes = new byte[cipherTextLength];
        ByteBuffer cipherText = ByteBuffer.wrap(cipherTextBytes);
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER);
            cipher.init(1, skeySpec);
            written = cipher.doFinal(dataBuf, cipherText);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No AES?", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException("Wrong padding?", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Bad key?", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Bad block size?", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Bad padding?", e);
        }
        catch (ShortBufferException e) {
            throw new IllegalArgumentException("Cipher buffer too short?", e);
        }
        byte[] version = new byte[]{1};
        byte[] intBytes = CommonUtils.intToByteArray(written);
        byte[] length = new byte[]{intBytes[2], intBytes[3]};
        try {
            mac = Mac.getInstance("hmacSHA256");
            mac.init(skeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No HMAC 256?", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Bad key?", e);
        }
        byte[] cipherBytes = new byte[written];
        System.arraycopy(cipherTextBytes, 0, cipherBytes, 0, cipherBytes.length);
        mac.update(version);
        mac.update(length);
        mac.update(cipherBytes);
        byte[] rawMac = mac.doFinal();
        byte[] full = CommonUtils.combine(version, length, cipherBytes, rawMac);
        return full;
    }

    public static byte[] decodeAllMessages(byte[] key, byte[] msgs) {
        ArrayList<byte[]> allDecoded = new ArrayList<byte[]>();
        AtomicInteger offset = new AtomicInteger(0);
        while (offset.get() < msgs.length) {
            byte[] decoded = CommonUtils.decodeSingleMessage(key, msgs, offset);
            allDecoded.add(decoded);
        }
        return CommonUtils.combine(allDecoded);
    }

    public static byte[] decodeSingleMessage(byte[] key, byte[] msg) {
        return CommonUtils.decodeSingleMessage(key, msg, new AtomicInteger(0));
    }

    public static byte[] decodeSingleMessage(byte[] key, byte[] msg, AtomicInteger atomicOffset) {
        Mac mac256;
        int bytesInOutput;
        int offset = atomicOffset.get();
        int size = CommonUtils.unsignedShortToInt(new byte[]{msg[offset + 1], msg[offset + 2]});
        int newOffset = offset + 3 + size + 32;
        atomicOffset.set(newOffset);
        byte[] rawMac = Arrays.copyOfRange(msg, offset + 3 + size, newOffset);
        SecretKeySpec skeySpec = new SecretKeySpec(key, DEFAULT_CIPHER);
        byte[] plainText = new byte[size];
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER);
            cipher.init(2, skeySpec);
            bytesInOutput = cipher.doFinal(msg, offset + 3, size, plainText);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No AES?", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException("No padding?", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Bad key?", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Bad block size?", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Bad padding?", e);
        }
        catch (ShortBufferException e) {
            throw new IllegalArgumentException("Buffer too short?", e);
        }
        try {
            mac256 = Mac.getInstance("hmacSHA256");
            mac256.init(skeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No hmacSHA256?", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Bad key?", e);
        }
        mac256.update(msg, offset, 3 + size);
        byte[] mac = mac256.doFinal();
        if (!Arrays.equals(mac, rawMac)) {
            LOG.error("MACs don't match!!");
            throw new IllegalArgumentException("Macs don't match!!");
        }
        if (bytesInOutput != plainText.length) {
            return Arrays.copyOf(plainText, bytesInOutput);
        }
        return plainText;
    }

    public static byte[] generateKey() {
        keyGenerator.init(128);
        SecretKey skey = keyGenerator.generateKey();
        return skey.getEncoded();
    }

    public static String generateBase64Key() {
        return Base64.encodeBase64String((byte[])CommonUtils.generateKey());
    }

    public static byte[] decodeBase64(String base64) {
        byte[] body;
        if (StringUtils.isBlank((String)base64)) {
            LOG.error("No data!!");
            body = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else {
            body = Base64.decodeBase64((String)base64);
        }
        return body;
    }

    public static String toHex(byte[] data) {
        return new String(Hex.encodeHex((byte[])data));
    }

    public static final int unsignedShortToInt(byte[] b) {
        int i = 0;
        i |= b[0] & 0xFF;
        i <<= 8;
        return i |= b[1] & 0xFF;
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int randomPort() {
        for (int i = 0; i < 20; ++i) {
            int randomPort = 1024 + Math.abs(secureRandom.nextInt() + 1) % 60000;
            ServerSocket sock = null;
            try {
                int port;
                sock = new ServerSocket();
                sock.bind(new InetSocketAddress("127.0.0.1", randomPort));
                int n = port = sock.getLocalPort();
                return n;
            }
            catch (IOException e) {
                LOG.info("Could not bind to port: {}", (Object)randomPort);
                continue;
            }
            finally {
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        ServerSocket sock = null;
        try {
            int port;
            sock = new ServerSocket();
            sock.bind(null);
            int n = port = sock.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LOG.info("Still could not bind?");
            int n = 1024 + Math.abs(secureRandom.nextInt() + 1) % 60000;
            return n;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        secureRandom = new SecureRandom();
        try {
            keyGenerator = KeyGenerator.getInstance(DEFAULT_CIPHER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No AES?", e);
        }
        littleShootProps = null;
        SIZE_LIMIT = (int)Math.pow(2.0, 15.0);
    }
}

