/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);

    public static String prettyS3Date(String dateString) {
        String formatString = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = format.parse(dateString);
            return new SimpleDateFormat("MMM d, ''yy, h:mm:ss a").format(date);
        }
        catch (ParseException e) {
            LOG.warn("Date not in expected format", (Throwable)e);
            return dateString;
        }
    }

    public static Date parseHttpDate(String httpDateString) throws DateParseException {
        return DateUtil.parseDate((String)httpDateString);
    }

    public static String createHttpDate() {
        return DateUtil.formatDate((Date)new Date());
    }

    public static String iso8601() {
        return DateUtils.iso8601(new Date());
    }

    public static String iso8601(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String result = dateFormatter.format(date);
        return result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
    }

    public static Date iso8601ToDate(String dateString) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String str = StringUtils.substringBeforeLast((String)dateString, (String)":") + StringUtils.substringAfterLast((String)dateString, (String)":");
        return df.parse(str);
    }
}

