/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.apache.commons.lang.SystemUtils;
import org.littleshoot.util.DaemonThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlockSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DeadlockSupport.class);
    private static final int DEADLOCK_CHECK_INTERVAL = 3001;

    public static void startDeadlockMonitoring() {
        DaemonThread t = new DaemonThread(new Runnable(){

            @Override
            public void run() {
                ThreadInfo[] allThreadInfo;
                long[] ids;
                while (true) {
                    try {
                        Thread.sleep(3001L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    LOG.trace("deadlock check start");
                    ids = DeadlockSupport.findDeadlockedThreads(ManagementFactory.getThreadMXBean());
                    if (ids != null) break;
                    LOG.trace("no deadlocks found");
                }
                StringBuilder sb = new StringBuilder("Deadlock Report:\n");
                StackTraceElement[] firstStackTrace = null;
                for (ThreadInfo info : allThreadInfo = DeadlockSupport.getThreadInfo(ids)) {
                    sb.append("\"" + info.getThreadName() + "\" (id=" + info.getThreadId() + ")");
                    sb.append(" " + (Object)((Object)info.getThreadState()) + " on " + info.getLockName() + " owned by ");
                    sb.append("\"" + info.getLockOwnerName() + "\" (id=" + info.getLockOwnerId() + ")");
                    if (info.isSuspended()) {
                        sb.append(" (suspended)");
                    }
                    if (info.isInNative()) {
                        sb.append(" (in native)");
                    }
                    sb.append("\n");
                    StackTraceElement[] trace = info.getStackTrace();
                    if (firstStackTrace == null) {
                        firstStackTrace = trace;
                    }
                    for (int i = 0; i < trace.length; ++i) {
                        sb.append("\tat " + trace[i].toString() + "\n");
                        if (i == 0) {
                            DeadlockSupport.addLockInfo(info, sb);
                        }
                        DeadlockSupport.addMonitorInfo(info, sb, i);
                    }
                    DeadlockSupport.addLockedSynchronizers(info, sb);
                    sb.append("\n");
                }
                Exception deadlock = new Exception();
                if (firstStackTrace != null) {
                    deadlock.setStackTrace(firstStackTrace);
                }
                LOG.error("Found deadlock", (Throwable)deadlock);
            }
        });
        t.setDaemon(true);
        t.setName("Deadlock Detection Thread");
        t.start();
    }

    private static void addLockedSynchronizers(ThreadInfo info, StringBuilder sb) {
        if (SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            try {
                int length;
                Method m = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                Object o = m.invoke((Object)info, new Object[0]);
                if (o != null && (length = Array.getLength(o)) > 0) {
                    sb.append("\n\tNumber of locked synchronizers = " + length + "\n");
                    for (int i = 0; i < length; ++i) {
                        sb.append("\t- " + Array.get(o, i) + "\n");
                    }
                }
            }
            catch (Throwable t) {
                LOG.trace("Error retrieving locked synchronizers", t);
            }
        }
    }

    private static void addMonitorInfo(ThreadInfo info, StringBuilder sb, int stackDepth) {
        if (SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            try {
                Method m = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                Object o = m.invoke((Object)info, new Object[0]);
                if (o != null) {
                    Class<?> monitorInfoClass = Class.forName("java.lang.management.MonitorInfo");
                    int length = Array.getLength(o);
                    for (int i = 0; i < length; ++i) {
                        Object mi = Array.get(o, i);
                        Method depthMethod = monitorInfoClass.getMethod("getLockedStackDepth", new Class[0]);
                        Object depth = depthMethod.invoke(mi, new Object[0]);
                        if (depth == null || !depth.equals(stackDepth)) continue;
                        sb.append("\t-  locked " + mi + "\n");
                    }
                }
            }
            catch (Throwable t) {
                LOG.trace("Error retrieving monitor info", t);
            }
        }
    }

    private static void addLockInfo(ThreadInfo info, StringBuilder sb) {
        if (SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            try {
                Method m = ThreadInfo.class.getMethod("getLockInfo", new Class[0]);
                Object o = m.invoke((Object)info, new Object[0]);
                if (o != null) {
                    Thread.State ts = info.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            sb.append("\t-  blocked on " + o + "\n");
                            break;
                        }
                        case WAITING: 
                        case TIMED_WAITING: {
                            sb.append("\t-  waiting on " + o + "\n");
                            break;
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.trace("Error calling getLockInfo", t);
            }
        }
    }

    private static long[] findDeadlockedThreads(ThreadMXBean bean) {
        if (SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            try {
                Method m = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                Object o = m.invoke((Object)bean, new Object[0]);
                if (o instanceof long[] || o == null) {
                    return (long[])o;
                }
            }
            catch (Throwable t) {
                LOG.error("Error calling findDeadlockedthreads", t);
            }
        }
        return bean.findMonitorDeadlockedThreads();
    }

    private static ThreadInfo[] getThreadInfo(long[] ids) {
        if (SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            try {
                Method m = ThreadMXBean.class.getDeclaredMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                Object o = m.invoke((Object)ManagementFactory.getThreadMXBean(), ids, true, true);
                return (ThreadInfo[])o;
            }
            catch (Throwable t) {
                LOG.trace("Error retrieving detailed thread info", t);
            }
        }
        return ManagementFactory.getThreadMXBean().getThreadInfo(ids, Integer.MAX_VALUE);
    }
}

