/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsUtil {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final InitialDirContext m_context;

    public DnsUtil() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("com.sun.jndi.dns.timeout.initial", "2000");
        env.put("com.sun.jndi.dns.timeout.retries", "3");
        this.m_context = new InitialDirContext(env);
        this.m_log.warn("Provider URL: {}", this.m_context.getEnvironment().get("java.naming.provider.url"));
    }

    public Attributes getARecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"A"});
    }

    public Attributes getPtrRecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"PTR"});
    }

    public Attributes getCnamRecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"CNAME"});
    }

    public Attributes getMxRecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"MX"});
    }

    public Attributes getSrvRecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"SRV"});
    }

    public Attributes getSoaRecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"SOA"});
    }

    public Attributes getNsRecords(String name) throws NamingException {
        return this.m_context.getAttributes(name, new String[]{"NS"});
    }

    public NamingEnumeration<Binding> getHostfile(String name) throws NamingException {
        return this.m_context.listBindings(name);
    }
}

