/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.littleshoot.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputRecord {
    private static final Logger log = LoggerFactory.getLogger(InputRecord.class);
    private static final int MAC_SIZE = 32;
    private int size = -1;
    private final byte[] readKey;
    private byte[] headerBytes = new byte[3];
    private final ByteBuffer header;
    private ByteBuffer curBuffer = this.header = ByteBuffer.wrap(this.headerBytes);
    private byte[] bodyBytes;
    private boolean needsData = true;
    private byte[] plainText;
    private int drainedIndex = 0;

    public InputRecord(byte[] readKey) {
        if (readKey == null) {
            log.error("Read key can't be null!!");
            throw new NullPointerException("Null read key");
        }
        this.readKey = readKey;
    }

    public boolean needsData() {
        return this.needsData;
    }

    public void addData(ByteBuffer bb) {
        if (this.curBuffer == this.header) {
            this.copyBytes(this.curBuffer, bb);
            if (this.curBuffer.hasRemaining()) {
                return;
            }
            this.size = CommonUtils.unsignedShortToInt(new byte[]{this.headerBytes[1], this.headerBytes[2]});
            this.bodyBytes = new byte[this.size + 32];
            this.curBuffer = ByteBuffer.wrap(this.bodyBytes);
            this.copyBytes(this.curBuffer, bb);
            if (this.curBuffer.hasRemaining()) {
                return;
            }
            this.decryptAndVerify(this.curBuffer);
        } else {
            this.copyBytes(this.curBuffer, bb);
            if (this.curBuffer.hasRemaining()) {
                return;
            }
            this.decryptAndVerify(this.curBuffer);
        }
    }

    private void decryptAndVerify(ByteBuffer bodyAndMac) {
        Mac mac256;
        byte[] plain;
        byte[] bodyAndMacBytes = bodyAndMac.array();
        byte[] cipherText = new byte[this.size];
        System.arraycopy(bodyAndMacBytes, 0, cipherText, 0, cipherText.length);
        byte[] rawMac = new byte[32];
        System.arraycopy(bodyAndMacBytes, cipherText.length, rawMac, 0, rawMac.length);
        SecretKeySpec skeySpec = new SecretKeySpec(this.readKey, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeySpec);
            plain = cipher.doFinal(cipherText);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No AES?", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException("No padding?", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Bad key? Read key is: " + Base64.encodeBase64String((byte[])this.readKey), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Bad block size?", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Bad padding?", e);
        }
        try {
            mac256 = Mac.getInstance("hmacSHA256");
            mac256.init(skeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No hmacSHA256?", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Bad key?", e);
        }
        mac256.update(this.headerBytes);
        mac256.update(cipherText);
        byte[] mac = mac256.doFinal();
        if (!Arrays.equals(mac, rawMac)) {
            log.error("MACs don't match!!");
            log.error("Decrypted: " + new String(plain));
            log.error("Tried to match original:\n" + CommonUtils.toHex(rawMac) + "\n" + CommonUtils.toHex(mac));
            throw new IllegalArgumentException("Macs don't match!!");
        }
        this.plainText = plain;
        this.needsData = false;
    }

    public int drainData(byte[] buf, int off, int len) {
        int remaining = this.plainText.length - this.drainedIndex;
        int toCopy = remaining > len ? len : remaining;
        System.arraycopy(this.plainText, this.drainedIndex, buf, off, toCopy);
        this.drainedIndex += toCopy;
        return toCopy;
    }

    public boolean hasMoreData() {
        int remaining = this.plainText.length - this.drainedIndex;
        return remaining > 0;
    }

    private void copyBytes(ByteBuffer buf1, ByteBuffer buf2) {
        while (buf1.hasRemaining() && buf2.hasRemaining()) {
            buf1.put(buf2.get());
        }
    }
}

