/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.LongRange;
import org.littleshoot.util.LongRangeListener;
import org.littleshoot.util.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IoUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static byte[] toByteArray(InputStream is, int length) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(length);
        IOUtils.copy((InputStream)is, (OutputStream)output);
        return output.toByteArray();
    }

    public static int copy(InputStream is, OutputStream os, WriteListener listener) throws IOException {
        if (is == null) {
            throw new NullPointerException("null input stream.");
        }
        if (os == null) {
            throw new NullPointerException("null output stream.");
        }
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = is.read(buffer))) {
            os.write(buffer, 0, n);
            listener.onBytesRead(n);
            count += n;
        }
        LOG.trace("Wrote " + count + " bytes.");
        return count;
    }

    public static long copy(InputStream in, OutputStream out, long originalByteCount) throws IOException {
        if (originalByteCount < 0L) {
            throw new IllegalArgumentException("Invalid byte count: " + originalByteCount);
        }
        byte[] buffer = new byte[4096];
        int len = 0;
        long written = 0L;
        long byteCount = originalByteCount;
        try {
            while (byteCount > 0L) {
                len = byteCount < 4096L ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, 4096);
                if (len == -1) {
                    LOG.debug("Breaking on length = -1");
                    break;
                }
                byteCount -= (long)len;
                LOG.info("Total written: " + written);
                out.write(buffer, 0, len);
                written += (long)len;
            }
            long l = written;
            return l;
        }
        catch (IOException e) {
            LOG.debug("Got IOException during copy after writing " + written + " of " + originalByteCount, (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            LOG.debug("Runtime error after writing " + written + " of " + originalByteCount, (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        finally {
            out.flush();
        }
    }

    public static long copy(InputStream is, RandomAccessFile raf, long offset, long length) throws IOException {
        return IoUtils.copy(is, raf, offset, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream is, RandomAccessFile raf, long offset, long length, LongRangeListener lrl, WriteListener wl) throws IOException {
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid byte count: " + length);
        }
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        long written = 0L;
        long filePosition = offset;
        try {
            while (length > 0L && (bytesRead = length < 4096L ? is.read(buffer, 0, (int)length) : is.read(buffer, 0, 4096)) != -1) {
                length -= (long)bytesRead;
                RandomAccessFile randomAccessFile = raf;
                synchronized (randomAccessFile) {
                    raf.seek(filePosition);
                    raf.write(buffer, 0, bytesRead);
                }
                if (wl != null) {
                    wl.onBytesRead(bytesRead);
                }
                if (lrl != null) {
                    lrl.onRangeComplete(new LongRange(filePosition, filePosition + (long)bytesRead - 1L));
                }
                filePosition += (long)bytesRead;
                written += (long)bytesRead;
            }
            return written;
        }
        catch (IOException e) {
            LOG.debug("Got IOException during copy", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.warn("Runtime error", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] deflate(String str) {
        byte[] byArray;
        GZIPOutputStream os = null;
        ByteArrayOutputStream baos = null;
        byte[] raw = null;
        try {
            raw = str.getBytes("UTF-8");
            baos = new ByteArrayOutputStream();
            os = new GZIPOutputStream(baos);
            os.write(raw);
            os.finish();
            baos.close();
            byArray = baos.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding??", (Throwable)e);
            byte[] byArray2 = raw;
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((OutputStream)baos);
            return byArray2;
        }
        catch (IOException e2) {
            LOG.error("Could not deflate!!", (Throwable)e2);
            byte[] byArray3 = raw;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    IOUtils.closeQuietly(baos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((OutputStream)baos);
            return byArray3;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((OutputStream)baos);
        return byArray;
    }

    public static String inflateString(byte[] bytes) {
        try {
            return new String(IoUtils.inflate(bytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding??", (Throwable)e);
            return new String(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] inflate(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new IllegalArgumentException("Null bytes argument");
        }
        if (bytes.length == 0) {
            LOG.warn("Received empty byte array!!");
            return bytes;
        }
        ByteArrayInputStream bais = null;
        GZIPInputStream is = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            is = new GZIPInputStream(bais);
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding??", (Throwable)e);
            byte[] byArray2 = bytes;
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)bais);
            return byArray2;
        }
        catch (IOException e2) {
            try {
                LOG.error("Could not inflate: " + new String(bytes, "UTF-8"), (Throwable)e2);
            }
            catch (UnsupportedEncodingException e1) {
                LOG.error("Encoding??", (Throwable)e2);
            }
            byte[] byArray3 = bytes;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly((InputStream)bais);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)bais);
            return byArray3;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)bais);
        return byArray;
    }
}

