/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.littleshoot.util.FileLockUtils;
import org.littleshoot.util.LockedFileProcessor;
import org.littleshoot.util.LockedFileReader;
import org.littleshoot.util.LockedFileRunner;
import org.littleshoot.util.LockedFileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedFileProcessorImpl
implements LockedFileProcessor {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final LockedFileReader m_reader;
    private final File m_lockFile;
    private final File m_dataFile;

    public LockedFileProcessorImpl(LockedFileReader reader, File lockFile, File dataFile) {
        this.m_reader = reader;
        this.m_lockFile = lockFile;
        this.m_dataFile = dataFile;
    }

    @Override
    public void processFile() {
        LockedFileWatcher tt = new LockedFileWatcher(this.m_dataFile){

            @Override
            protected void onFileChange(FileChannel fc) {
                LockedFileProcessorImpl.this.readFileData(fc);
            }
        };
        Timer timer = new Timer("Lock-File-Timer-Thread", true);
        timer.schedule((TimerTask)tt, 0L, 800L);
    }

    private void readFileData(final FileChannel dataFileChannel) {
        LockedFileRunner runner = new LockedFileRunner(){

            @Override
            public void callWithLock(FileChannel lockFileChannel) {
                LockedFileProcessorImpl.this.processDataFile(dataFileChannel);
            }
        };
        if (this.m_lockFile.length() > 0L) {
            this.m_log.error("The lock file has data!");
        }
        FileLockUtils.callWithLock(this.m_lockFile, runner, false);
    }

    private void processDataFile(FileChannel dataFileChannel) {
        try {
            this.m_reader.readFile(dataFileChannel);
        }
        catch (IOException e) {
            this.m_log.warn("Exception reading file", (Throwable)e);
        }
    }
}

