/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.nio.channels.FileChannel;
import java.util.TimerTask;
import org.littleshoot.util.FileLockUtils;
import org.littleshoot.util.LockedFileRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LockedFileWatcher
extends TimerTask {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final File m_file;

    public LockedFileWatcher(File file) {
        this.m_file = file;
    }

    @Override
    public final void run() {
        if (this.m_file.length() != 0L) {
            LockedFileRunner runner = new LockedFileRunner(){

                @Override
                public void callWithLock(FileChannel fc) {
                    LockedFileWatcher.this.onFileChange(fc);
                }
            };
            FileLockUtils.callWithLock(this.m_file, runner, true);
        }
    }

    protected abstract void onFileChange(FileChannel var1);
}

