/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.littleshoot.util.SessionSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayingSocketHandler
implements SessionSocketListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int SMALL_BUFFER_SIZE = 4096;
    private static final int LARGE_BUFFER_SIZE = 16384;
    private final InetSocketAddress serverAddress;

    public RelayingSocketHandler(InetSocketAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public void onSocket(String id, Socket encryptedSocket) throws IOException {
        this.log.info("Relaying socket connecting to: {}", (Object)this.serverAddress);
        Socket relay = new Socket();
        relay.connect(this.serverAddress, 30000);
        relay.setSoTimeout(300000);
        OutputStream externalOs = encryptedSocket.getOutputStream();
        InputStream externalIs = encryptedSocket.getInputStream();
        OutputStream relayOs = relay.getOutputStream();
        InputStream relayIs = relay.getInputStream();
        this.threadedCopy(externalIs, relayOs, "ReadFromExternal", 4096, encryptedSocket);
        this.threadedCopy(relayIs, externalOs, "WriteToExternal", 16384, encryptedSocket);
    }

    private void threadedCopy(final InputStream is, final OutputStream os, final String threadNameId, final int bufferSize, final Socket sock) {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RelayingSocketHandler.this.copyLarge(is, os, bufferSize);
                }
                catch (IOException e) {
                    RelayingSocketHandler.this.log.debug("Error copying socket data on " + threadNameId, (Throwable)e);
                }
                catch (Throwable t) {
                    RelayingSocketHandler.this.log.warn("Error copying socket data on " + threadNameId, t);
                }
                finally {
                    try {
                        os.flush();
                    }
                    catch (IOException e1) {}
                    IOUtils.closeQuietly((OutputStream)os);
                    IOUtils.closeQuietly((InputStream)is);
                    RelayingSocketHandler.this.log.info("Closing socket...already closed streams...");
                    IOUtils.closeQuietly((Socket)sock);
                }
            }
        };
        Thread thread = new Thread(runner, "RelayingSocketHandler-Thread-" + threadNameId + "-" + runner.hashCode());
        thread.setDaemon(true);
        thread.start();
    }

    private long copyLarge(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        this.log.debug("Copied bytes: {}", (Object)count);
        return count;
    }

    @Override
    public void reconnected() {
    }
}

