/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import org.apache.commons.httpclient.ConnectionPoolTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettingMultiThreadedHttpConnectionManager
extends MultiThreadedHttpConnectionManager {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Protocol HTTP_PROT = new Protocol("http", (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), 80);
    private static final Protocol HTTPS_PROT = new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(), 443);

    public HttpConnection getConnection(HostConfiguration hc) {
        this.m_log.debug("Getting connection...");
        this.useDefaultProtocols(hc);
        HttpConnection conn = super.getConnection(hc);
        this.m_log.debug("Returning connection...");
        return conn;
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hc, long timeout) throws ConnectionPoolTimeoutException {
        this.m_log.debug("Getting connection...");
        this.useDefaultProtocols(hc);
        HttpConnection conn = super.getConnectionWithTimeout(hc, timeout);
        this.m_log.debug("Returning connection...");
        return conn;
    }

    private void useDefaultProtocols(HostConfiguration hc) {
        String scheme;
        Protocol p = hc.getProtocol();
        if (p == HTTP_PROT || p == HTTPS_PROT) {
            this.m_log.debug("Protocol already set...");
            return;
        }
        String string = scheme = p == null ? "" : p.getScheme();
        if (scheme.equalsIgnoreCase("http")) {
            HttpHost host = new HttpHost(hc.getHost(), hc.getPort(), HTTP_PROT);
            hc.setHost(host);
        } else if (scheme.equalsIgnoreCase("https")) {
            HttpHost host = new HttpHost(hc.getHost(), hc.getPort(), HTTPS_PROT);
            hc.setHost(host);
        }
    }
}

