/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.SrvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvCandidateProvider
implements CandidateProvider<InetSocketAddress> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final InetSocketAddress m_fallbackAddress;
    private final String m_srvAddress;
    private Collection<InetSocketAddress> m_addresses = new HashSet<InetSocketAddress>();
    private SrvUtil m_srvUtil;
    private boolean m_srvSucceeded;

    public SrvCandidateProvider(SrvUtil srvUtil, String srvAddress) {
        this(srvUtil, srvAddress, null);
    }

    public SrvCandidateProvider(SrvUtil srvUtil, String srvAddress, InetSocketAddress defaultAddress) {
        this.m_srvUtil = srvUtil;
        this.m_srvAddress = srvAddress;
        this.m_fallbackAddress = defaultAddress;
        this.m_addresses = this.getCandidates();
    }

    @Override
    public Collection<InetSocketAddress> getCandidates() {
        this.m_log.info("Getting SRV candidates");
        if (!this.m_addresses.isEmpty()) {
            return this.m_addresses;
        }
        if (this.m_srvSucceeded) {
            return Collections.emptyList();
        }
        this.m_log.info("Continuing with lookup");
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        if (StringUtils.isNotBlank((String)this.m_srvAddress)) {
            for (int i = 0; i < 2; ++i) {
                try {
                    Collection<InetSocketAddress> srvAddresses = this.m_srvUtil.getAddresses(this.m_srvAddress);
                    this.m_log.info("Got SRV addresses: {}", srvAddresses);
                    addresses.addAll(srvAddresses);
                    this.m_srvSucceeded = true;
                    break;
                }
                catch (IOException e) {
                    this.m_log.warn("SRV lookup error!", (Throwable)e);
                    continue;
                }
            }
        }
        if (!this.m_srvSucceeded && this.m_fallbackAddress != null) {
            this.m_log.warn("Adding fallback address: {}", (Object)this.m_fallbackAddress);
            addresses.add(this.m_fallbackAddress);
        }
        this.m_addresses = addresses;
        return addresses;
    }

    @Override
    public InetSocketAddress getCandidate() {
        Collection<InetSocketAddress> candidates = this.getCandidates();
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.iterator().next();
    }
}

