/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);

    private ThreadUtils() {
    }

    public static void safeWait(Object object) {
        try {
            object.wait();
        }
        catch (InterruptedException ie) {
            LOG.warn("Unexpected interrupted exception", (Throwable)ie);
        }
    }

    public static void safeWait(Object object, int millis) {
        try {
            object.wait(millis);
        }
        catch (InterruptedException ie) {
            LOG.warn("Unexpected interrupted exception", (Throwable)ie);
        }
    }

    public static void safeSleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ie) {
            LOG.warn("Unexpected interrupted exception", (Throwable)ie);
        }
    }

    public static String dumpStack() {
        return ThreadUtils.dumpStack(new Exception("Stack Dump Generated Exception"));
    }

    public static String dumpStack(Throwable cause) {
        if (cause == null) {
            return "Throwable was null";
        }
        StringWriter sw = new StringWriter();
        PrintWriter s = new PrintWriter(sw);
        cause.printStackTrace(s);
        String stack = sw.toString();
        try {
            sw.close();
        }
        catch (IOException e) {
            LOG.warn("Could not close writer", (Throwable)e);
        }
        s.close();
        return stack;
    }
}

