/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private Class<? extends TransactionFactory> transactionFactoryClass = SpringManagedTransactionFactory.class;
    private Properties transactionFactoryProperties;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfigurationProperties(Properties sqlSessionFactoryProperties) {
        this.configurationProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public <TF extends TransactionFactory> void setTransactionFactoryClass(Class<TF> transactionFactoryClass) {
        this.transactionFactoryClass = transactionFactoryClass;
    }

    public void setTransactionFactoryProperties(Properties transactionFactoryProperties) {
        this.transactionFactoryProperties = transactionFactoryProperties;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        Assert.notNull(this.transactionFactoryClass, (String)"Property 'transactionFactoryClass' is required");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException, IllegalAccessException, InstantiationException {
        Configuration configuration;
        if (this.configLocation != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(this.configLocation.getInputStream());
                XMLConfigBuilder xmlConfigBuilder = new XMLConfigBuilder((Reader)reader, null, this.configurationProperties);
                configuration = xmlConfigBuilder.parse();
            }
            catch (IOException ex) {
                throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException ignored) {}
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parsed configuration file: '" + this.configLocation + "'");
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Property 'configLocation' not specified, using default MyBatis Configuration");
            }
            configuration = new Configuration();
        }
        TransactionFactory transactionFactory = this.transactionFactoryClass.newInstance();
        transactionFactory.setProperties(this.transactionFactoryProperties);
        Environment environment = new Environment(this.environment, transactionFactory, this.dataSource);
        configuration.setEnvironment(environment);
        if (!ObjectUtils.isEmpty((Object[])this.mapperLocations)) {
            HashMap sqlFragments = new HashMap();
            for (Resource mapperLocation : this.mapperLocations) {
                if (mapperLocation == null) continue;
                String path = mapperLocation instanceof ClassPathResource ? ((ClassPathResource)mapperLocation).getPath() : mapperLocation.toString();
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(mapperLocation.getInputStream());
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder((Reader)reader, configuration, path, sqlFragments);
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException ignored) {}
                    }
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Parsed mapper file: '" + mapperLocation + "'");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Property 'mapperLocations' was not specified, only MyBatis mapper files specified in the config xml were loaded");
        }
        return this.sqlSessionFactoryBuilder.build(configuration);
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

