/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.logging.PrefixedLogger;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;

public class NetworkSession {
    private static final String LOG_NAME = "Session";
    private final ConnectionProvider connectionProvider;
    private final NetworkSessionConnectionContext connectionContext;
    private final AccessMode mode;
    private final RetryLogic retryLogic;
    protected final Logger logger;
    private final BookmarkHolder bookmarkHolder;
    private volatile CompletionStage<ExplicitTransaction> transactionStage = Futures.completedWithNull();
    private volatile CompletionStage<Connection> connectionStage = Futures.completedWithNull();
    private volatile CompletionStage<? extends FailableCursor> resultCursorStage = Futures.completedWithNull();
    private final AtomicBoolean open = new AtomicBoolean(true);

    public NetworkSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, String databaseName, AccessMode mode, BookmarkHolder bookmarkHolder, Logging logging) {
        this.connectionProvider = connectionProvider;
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logger = new PrefixedLogger("[" + this.hashCode() + "]", logging.getLog(LOG_NAME));
        this.bookmarkHolder = bookmarkHolder;
        this.connectionContext = new NetworkSessionConnectionContext(databaseName, bookmarkHolder.getBookmark());
    }

    public CompletionStage<StatementResultCursor> runAsync(Statement statement, TransactionConfig config, boolean waitForRunResponse) {
        CompletionStage<StatementResultCursor> newResultCursorStage = this.buildResultCursorFactory(statement, config, waitForRunResponse).thenCompose(StatementResultCursorFactory::asyncResult);
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage.thenApply(cursor -> cursor);
    }

    public CompletionStage<RxStatementResultCursor> runRx(Statement statement, TransactionConfig config) {
        CompletionStage<RxStatementResultCursor> newResultCursorStage = this.buildResultCursorFactory(statement, config, true).thenCompose(StatementResultCursorFactory::rxResult);
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage;
    }

    public CompletionStage<ExplicitTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.beginTransactionAsync(this.mode, config);
    }

    public CompletionStage<ExplicitTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config) {
        this.ensureSessionIsOpen();
        CompletionStage<ExplicitTransaction> newTransactionStage = this.ensureNoOpenTxBeforeStartingTx().thenCompose(ignore -> this.acquireConnection(mode)).thenCompose(connection -> {
            ExplicitTransaction tx = new ExplicitTransaction((Connection)connection, this.bookmarkHolder);
            return tx.beginAsync(this.bookmarkHolder.getBookmark(), config);
        });
        CompletionStage<ExplicitTransaction> currentTransactionStage = this.transactionStage;
        this.transactionStage = newTransactionStage.exceptionally(error -> null).thenCompose(tx -> {
            if (tx == null) {
                return currentTransactionStage;
            }
            return CompletableFuture.completedFuture(tx);
        });
        return newTransactionStage;
    }

    public CompletionStage<Void> resetAsync() {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                tx.markTerminated();
            }
        }).thenCompose(ignore -> this.connectionStage).thenCompose(connection -> {
            if (connection != null) {
                return connection.reset();
            }
            return Futures.completedWithNull();
        });
    }

    public RetryLogic retryLogic() {
        return this.retryLogic;
    }

    public Bookmark lastBookmark() {
        return this.bookmarkHolder.getBookmark();
    }

    public CompletionStage<Void> releaseConnectionAsync() {
        return this.connectionStage.thenCompose(connection -> {
            if (connection != null) {
                return connection.release();
            }
            return Futures.completedWithNull();
        });
    }

    public CompletionStage<Connection> connectionAsync() {
        return this.connectionStage;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public CompletionStage<Void> closeAsync() {
        if (this.open.compareAndSet(true, false)) {
            return this.resultCursorStage.thenCompose(cursor -> {
                if (cursor != null) {
                    return cursor.failureAsync();
                }
                return Futures.completedWithNull();
            }).thenCompose(cursorError -> this.closeTransactionAndReleaseConnection().thenApply(txCloseError -> {
                CompletionException combinedError = Futures.combineErrors(cursorError, txCloseError);
                if (combinedError != null) {
                    throw combinedError;
                }
                return null;
            }));
        }
        return Futures.completedWithNull();
    }

    protected CompletionStage<Boolean> currentConnectionIsOpen() {
        return this.connectionStage.handle((connection, error) -> error == null && connection != null && connection.isOpen());
    }

    private CompletionStage<StatementResultCursorFactory> buildResultCursorFactory(Statement statement, TransactionConfig config, boolean waitForRunResponse) {
        this.ensureSessionIsOpen();
        return this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            try {
                StatementResultCursorFactory factory = connection.protocol().runInAutoCommitTransaction((Connection)connection, statement, this.bookmarkHolder, config, waitForRunResponse);
                return CompletableFuture.completedFuture(factory);
            }
            catch (Throwable e) {
                return Futures.failedFuture(e);
            }
        });
    }

    private CompletionStage<Connection> acquireConnection(AccessMode mode) {
        CompletionStage<Connection> currentConnectionStage = this.connectionStage;
        CompletionStage<Connection> newConnectionStage = this.resultCursorStage.thenCompose(cursor -> {
            if (cursor == null) {
                return Futures.completedWithNull();
            }
            return cursor.failureAsync();
        }).thenCompose(error -> {
            if (error == null) {
                return currentConnectionStage.exceptionally(ignore -> null);
            }
            throw new CompletionException((Throwable)error);
        }).thenCompose(existingConnection -> {
            if (existingConnection != null && existingConnection.isOpen()) {
                throw new IllegalStateException("Existing open connection detected");
            }
            return this.connectionProvider.acquireConnection(this.connectionContext.contextWithMode(mode));
        });
        this.connectionStage = newConnectionStage.exceptionally(error -> null);
        return newConnectionStage;
    }

    private CompletionStage<Throwable> closeTransactionAndReleaseConnection() {
        return this.existingTransactionOrNull().thenCompose(tx -> {
            if (tx != null) {
                return tx.closeAsync().thenApply(ignore -> null).exceptionally(error -> error);
            }
            return Futures.completedWithNull();
        }).thenCompose(txCloseError -> this.releaseConnectionAsync().thenApply(ignore -> txCloseError));
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeRunningQuery() {
        return this.ensureNoOpenTx("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeStartingTx() {
        return this.ensureNoOpenTx("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTx(String errorMessage) {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                throw new ClientException(errorMessage);
            }
        });
    }

    private CompletionStage<ExplicitTransaction> existingTransactionOrNull() {
        return this.transactionStage.exceptionally(error -> null).thenApply(tx -> tx != null && tx.isOpen() ? tx : null);
    }

    private void ensureSessionIsOpen() {
        if (!this.open.get()) {
            throw new ClientException("No more interaction with this session are allowed as the current session is already closed. ");
        }
    }

    private class NetworkSessionConnectionContext
    implements ConnectionContext {
        private final String databaseName;
        private AccessMode mode;
        private final InternalBookmark rediscoveryBookmark;

        private NetworkSessionConnectionContext(String databaseName, InternalBookmark bookmark) {
            this.databaseName = databaseName;
            this.rediscoveryBookmark = bookmark;
        }

        private ConnectionContext contextWithMode(AccessMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public String databaseName() {
            return this.databaseName;
        }

        @Override
        public AccessMode mode() {
            return this.mode;
        }

        @Override
        public InternalBookmark rediscoveryBookmark() {
            return this.rediscoveryBookmark;
        }
    }
}

