/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;

@RunWith(value=Parameterized.class)
public abstract class PageSwappingTest {
    private static PageEvictionCallback NO_CALLBACK = new PageEvictionCallback(){

        public void onEvict(long pageId, Page page) {
        }
    };
    private static EphemeralFileSystemAbstraction fs;
    private final PageSwapperFactory swapperFactory;
    private final int cachePageSize = 32;

    @BeforeClass
    public static void setUp() {
        Thread.interrupted();
        fs = new EphemeralFileSystemAbstraction();
    }

    @AfterClass
    public static void tearDown() {
        fs.shutdown();
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> dataPoints() {
        Factory<PageSwapperFactory> singleFileSwapper = new Factory<PageSwapperFactory>(){

            public PageSwapperFactory newInstance() {
                return new SingleFilePageSwapperFactory((FileSystemAbstraction)fs);
            }
        };
        return Arrays.asList(new Object[][]{{singleFileSwapper}});
    }

    public PageSwappingTest(Factory<PageSwapperFactory> fixture) {
        this.swapperFactory = (PageSwapperFactory)fixture.newInstance();
    }

    protected abstract Page createPage(int var1);

    protected abstract long writeLock(Page var1);

    protected abstract void unlockWrite(Page var1, long var2);

    protected abstract long getLong(Page var1, int var2);

    protected abstract int getInt(Page var1, int var2);

    protected abstract void putLong(Page var1, long var2, int var4);

    protected abstract void putInt(Page var1, int var2, int var3);

    @Before
    @After
    public void clearStrayInterrupts() {
        Thread.interrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void swappingOutMustNotSwallowInterrupts() throws IOException {
        File file = new File("a");
        fs.create(file).close();
        Page page = this.createPage(32);
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        Thread.currentThread().interrupt();
        long stamp = this.writeLock(page);
        try {
            swapper.write(0L, page);
            Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            this.unlockWrite(page, stamp);
        }
    }

    @Test
    public void forcingMustNotSwallowInterrupts() throws IOException {
        File file = new File("a");
        fs.create(file).close();
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        Thread.currentThread().interrupt();
        swapper.force();
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustReopenChannelWhenReadFailsWithAsynchronousCloseException() throws IOException {
        long x = ThreadLocalRandom.current().nextLong();
        long y = ThreadLocalRandom.current().nextLong();
        int z = ThreadLocalRandom.current().nextInt();
        Page page = this.createPage(32);
        File file = new File("a");
        StoreChannel channel = fs.create(file);
        ByteBuffer buf = ByteBuffer.allocate(32);
        buf.putLong(x);
        buf.putLong(y);
        buf.putInt(z);
        buf.flip();
        channel.writeAll(buf);
        channel.close();
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        Thread.currentThread().interrupt();
        long stamp = this.writeLock(page);
        try {
            swapper.read(0L, page);
        }
        finally {
            this.unlockWrite(page, stamp);
        }
        Assert.assertTrue((boolean)Thread.interrupted());
        Assert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)x));
        Assert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)y));
        Assert.assertThat((Object)this.getInt(page, 16), (Matcher)Matchers.is((Object)z));
        swapper.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustReopenChannelWhenWriteFailsWithAsynchronousCloseException() throws IOException {
        long x = ThreadLocalRandom.current().nextLong();
        long y = ThreadLocalRandom.current().nextLong();
        int z = ThreadLocalRandom.current().nextInt();
        Page page = this.createPage(32);
        this.putLong(page, x, 0);
        this.putLong(page, y, 8);
        this.putInt(page, z, 16);
        File file = new File("a");
        fs.create(file).close();
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        Thread.currentThread().interrupt();
        long stamp = this.writeLock(page);
        try {
            swapper.write(0L, page);
        }
        finally {
            this.unlockWrite(page, stamp);
        }
        Assert.assertTrue((boolean)Thread.interrupted());
        swapper.force();
        ByteBuffer buf = ByteBuffer.allocate(32);
        StoreChannel channel = fs.open(file, "r");
        int bytesRead = channel.read(buf);
        channel.close();
        Assert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)32));
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)x));
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)y));
        Assert.assertThat((Object)buf.getInt(), (Matcher)Matchers.is((Object)z));
    }

    @Test
    public void mustReopenChannelWhenForceFailsWithAsynchronousCloseException() throws IOException {
        File file = new File("a");
        fs.create(file).close();
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        for (int i = 0; i < 10; ++i) {
            Thread.currentThread().interrupt();
            swapper.force();
            Assert.assertTrue((boolean)Thread.interrupted());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readMustNotReopenExplicitlyClosedChannel() throws IOException {
        File file = new File("a");
        StoreChannel channel = fs.create(file);
        ByteBuffer buf = ByteBuffer.allocate(32);
        channel.writeAll(buf);
        channel.close();
        Page page = this.createPage(32);
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        swapper.close();
        long stamp = this.writeLock(page);
        try {
            swapper.read(0L, page);
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException ignore) {
        }
        finally {
            this.unlockWrite(page, stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeMustNotReopenExplicitlyClosedChannel() throws IOException {
        File file = new File("a");
        fs.create(file).close();
        Page page = this.createPage(32);
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        swapper.close();
        long stamp = this.writeLock(page);
        try {
            swapper.write(0L, page);
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException ignore) {
        }
        finally {
            this.unlockWrite(page, stamp);
        }
    }

    @Test
    public void forceMustNotReopenExplicitlyClosedChannel() throws IOException {
        File file = new File("a");
        fs.create(file).close();
        PageSwapper swapper = this.swapperFactory.createPageSwapper(file, 32, NO_CALLBACK);
        swapper.close();
        try {
            swapper.force();
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }
}

