/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.randomharness.Action;
import org.neo4j.io.pagecache.randomharness.Command;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;

class CommandPrimer {
    private final Random rng;
    private final MuninnPageCache cache;
    private final File[] files;
    private final Map<File, PagedFile> fileMap;
    private final Map<File, List<Integer>> recordsWrittenTo;
    private final List<File> mappedFiles;
    private final Set<File> filesTouched;
    private final int filePageCount;
    private final int filePageSize;
    private final RecordFormat recordFormat;

    public CommandPrimer(Random rng, MuninnPageCache cache, File[] files, Map<File, PagedFile> fileMap, int filePageCount, int filePageSize, RecordFormat recordFormat) {
        this.rng = rng;
        this.cache = cache;
        this.files = files;
        this.fileMap = fileMap;
        this.filePageCount = filePageCount;
        this.filePageSize = filePageSize;
        this.recordFormat = recordFormat;
        this.mappedFiles = new ArrayList<File>();
        this.mappedFiles.addAll(fileMap.keySet());
        this.filesTouched = new HashSet<File>();
        this.filesTouched.addAll(this.mappedFiles);
        this.recordsWrittenTo = new HashMap<File, List<Integer>>();
        for (File file : files) {
            this.recordsWrittenTo.put(file, new ArrayList());
        }
    }

    public List<File> getMappedFiles() {
        return this.mappedFiles;
    }

    public Set<File> getFilesTouched() {
        return this.filesTouched;
    }

    public Action prime(Command command) {
        switch (command) {
            case FlushCache: {
                return this.flushCache();
            }
            case FlushFile: {
                return this.flushFile();
            }
            case MapFile: {
                return this.mapFile();
            }
            case UnmapFile: {
                return this.unmapFile();
            }
            case ReadRecord: {
                return this.readRecord();
            }
            case WriteRecord: {
                return this.writeRecord();
            }
        }
        throw new IllegalArgumentException("Unknown command: " + (Object)((Object)command));
    }

    private Action flushCache() {
        return new Action(Command.FlushCache, "", new Object[0]){

            @Override
            public void perform() throws Exception {
                CommandPrimer.this.cache.flushAndForce();
            }
        };
    }

    private Action flushFile() {
        if (this.mappedFiles.size() > 0) {
            final File file = this.mappedFiles.get(this.rng.nextInt(this.mappedFiles.size()));
            return new Action(Command.FlushFile, "[file=%s]", new Object[]{file.getName()}){

                @Override
                public void perform() throws Exception {
                    PagedFile pagedFile = (PagedFile)CommandPrimer.this.fileMap.get(file);
                    if (pagedFile != null) {
                        pagedFile.flushAndForce();
                    }
                }
            };
        }
        return new Action(Command.FlushFile, "[no files mapped to flush]", new Object[0]){

            @Override
            public void perform() throws Exception {
            }
        };
    }

    private Action mapFile() {
        final File file = this.files[this.rng.nextInt(this.files.length)];
        this.mappedFiles.add(file);
        this.filesTouched.add(file);
        return new Action(Command.MapFile, "[file=%s]", new Object[]{file}){

            @Override
            public void perform() throws Exception {
                CommandPrimer.this.fileMap.put(file, CommandPrimer.this.cache.map(file, CommandPrimer.this.filePageSize));
            }
        };
    }

    private Action unmapFile() {
        if (this.mappedFiles.size() > 0) {
            final File file = this.mappedFiles.remove(this.rng.nextInt(this.mappedFiles.size()));
            return new Action(Command.UnmapFile, "[file=%s]", new Object[]{file}){

                @Override
                public void perform() throws Exception {
                    ((PagedFile)CommandPrimer.this.fileMap.get(file)).close();
                }
            };
        }
        return null;
    }

    private Action readRecord() {
        int mappedFilesCount = this.mappedFiles.size();
        if (mappedFilesCount == 0) {
            return null;
        }
        final File file = this.mappedFiles.get(this.rng.nextInt(mappedFilesCount));
        List<Integer> recordsWritten = this.recordsWrittenTo.get(file);
        int recordSize = this.recordFormat.getRecordSize();
        int recordsPerPage = this.cache.pageSize() / recordSize;
        int recordId = recordsWritten.isEmpty() ? this.rng.nextInt(this.filePageCount * recordsPerPage) : recordsWritten.get(this.rng.nextInt(recordsWritten.size())).intValue();
        final int pageId = recordId / recordsPerPage;
        final int pageOffset = recordId % recordsPerPage * recordSize;
        final Record expectedRecord = this.recordFormat.createRecord(file, recordId);
        return new Action(Command.ReadRecord, "[file=%s, recordId=%s, pageId=%s, pageOffset=%s, expectedRecord=%s]", new Object[]{file, recordId, pageId, pageOffset, expectedRecord}){

            @Override
            public void perform() throws Exception {
                PagedFile pagedFile = (PagedFile)CommandPrimer.this.fileMap.get(file);
                if (pagedFile != null) {
                    try (PageCursor cursor = pagedFile.io((long)pageId, 1);){
                        if (cursor.next()) {
                            cursor.setOffset(pageOffset);
                            Record actualRecord = CommandPrimer.this.recordFormat.readRecord(cursor);
                            Assert.assertThat((Object)actualRecord, (Matcher)Matchers.isOneOf((Object[])new Record[]{expectedRecord, CommandPrimer.this.recordFormat.zeroRecord()}));
                        }
                    }
                }
            }
        };
    }

    private Action writeRecord() {
        int mappedFilesCount = this.mappedFiles.size();
        if (mappedFilesCount == 0) {
            return null;
        }
        final File file = this.mappedFiles.get(this.rng.nextInt(mappedFilesCount));
        this.filesTouched.add(file);
        int recordSize = 16;
        int recordsPerPage = this.cache.pageSize() / recordSize;
        int recordId = this.rng.nextInt(this.filePageCount * recordsPerPage);
        this.recordsWrittenTo.get(file).add(recordId);
        final int pageId = recordId / recordsPerPage;
        final int pageOffset = recordId % recordsPerPage * recordSize;
        final Record record = this.recordFormat.createRecord(file, recordId);
        return new Action(Command.WriteRecord, "[file=%s, recordId=%s, pageId=%s, pageOffset=%s, record=%s]", new Object[]{file, recordId, pageId, pageOffset, record}){

            @Override
            public void perform() throws Exception {
                PagedFile pagedFile = (PagedFile)CommandPrimer.this.fileMap.get(file);
                if (pagedFile != null) {
                    try (PageCursor cursor = pagedFile.io((long)pageId, 2);){
                        if (cursor.next()) {
                            cursor.setOffset(pageOffset);
                            CommandPrimer.this.recordFormat.write(record, cursor);
                        }
                    }
                }
            }
        };
    }
}

