/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.randomharness.Record;

public abstract class RecordFormat {
    public abstract int getRecordSize();

    public abstract Record createRecord(File var1, int var2);

    public abstract Record readRecord(PageCursor var1) throws IOException;

    public abstract Record zeroRecord();

    public abstract void write(Record var1, PageCursor var2);

    public final void writeRecord(PageCursor cursor) {
        int recordsPerPage = cursor.getCurrentPageSize() / this.getRecordSize();
        this.writeRecordToPage(cursor, cursor.getCurrentPageId(), recordsPerPage);
    }

    public final void fillWithRecords(PageCursor cursor) {
        cursor.setOffset(0);
        int recordsPerPage = cursor.getCurrentPageSize() / this.getRecordSize();
        for (int i = 0; i < recordsPerPage; ++i) {
            this.writeRecordToPage(cursor, cursor.getCurrentPageId(), recordsPerPage);
        }
    }

    private void writeRecordToPage(PageCursor cursor, long pageId, int recordsPerPage) {
        int pageRecordId = cursor.getOffset() / this.getRecordSize();
        int recordId = (int)(pageId * (long)recordsPerPage + (long)pageRecordId);
        Record record = this.createRecord(cursor.getCurrentFile(), recordId);
        this.write(record, cursor);
    }

    public final void assertRecordsWrittenCorrectly(PageCursor cursor) throws IOException {
        int recordsPerPage = cursor.getCurrentPageSize() / this.getRecordSize();
        for (int pageRecordId = 0; pageRecordId < recordsPerPage; ++pageRecordId) {
            Record actualRecord;
            int recordId = (int)(cursor.getCurrentPageId() * (long)recordsPerPage + (long)pageRecordId);
            Record expectedRecord = this.createRecord(cursor.getCurrentFile(), recordId);
            int offset = cursor.getOffset();
            do {
                cursor.setOffset(offset);
                actualRecord = this.readRecord(cursor);
            } while (cursor.shouldRetry());
            Assert.assertThat((Object)actualRecord, (Matcher)Matchers.isOneOf((Object[])new Record[]{expectedRecord, this.zeroRecord()}));
        }
    }
}

